/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.ParseIssue;

public class GalimatiasParseException
extends Exception {
    private ParseIssue parseIssue = ParseIssue.UNSPECIFIED;
    private int position = -1;

    private GalimatiasParseException() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public GalimatiasParseException(String message) {
        super(message);
    }

    public GalimatiasParseException(String message, int position) {
        super(message);
        this.position = position;
    }

    public GalimatiasParseException(String message, ParseIssue parseIssue, int position, Throwable exception) {
        super(message, exception);
        if (parseIssue != null) {
            this.parseIssue = parseIssue;
        }
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public ParseIssue getParseIssue() {
        return this.parseIssue;
    }

    public static class Builder {
        private String message;
        private ParseIssue parseIssue;
        private int position;
        private Throwable cause;

        private Builder() {
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withPosition(int position) {
            this.position = position;
            return this;
        }

        public Builder withParseIssue(ParseIssue parseIssue) {
            this.parseIssue = parseIssue;
            return this;
        }

        public Builder withCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public GalimatiasParseException build() {
            return new GalimatiasParseException(this.message, this.parseIssue, this.position, this.cause);
        }
    }
}

