/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.number;

import java.util.List;
import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntSet;

public class IrregularGroupFormatter
extends NumericGroupFormatter {
    private final IntSet groupingPositions;
    private final List<Integer> separators;

    public IrregularGroupFormatter(IntSet groupingPositions, List<Integer> sep, UnicodeString adjustedPicture) {
        this.groupingPositions = groupingPositions;
        this.separators = sep;
        this.adjustedPicture = adjustedPicture;
    }

    @Override
    public String format(String value) {
        StringValue in = new StringValue(value);
        int m = 0;
        int l = 0;
        while ((long)l < in.length()) {
            if (this.groupingPositions.contains(l)) {
                ++m;
            }
            ++l;
        }
        int[] out = new int[in.length32() + m];
        int j = 0;
        int k = out.length - 1;
        for (int i = in.length32() - 1; i >= 0; --i) {
            out[k--] = in.getContent().codePointAt(i);
            if (i <= 0 || !this.groupingPositions.contains(in.length32() - i)) continue;
            out[k--] = this.separators.get(j++);
        }
        return StringTool.fromCodePoints(out, out.length).toString();
    }

    @Override
    public String getSeparator() {
        if (this.separators.size() == 0) {
            return null;
        }
        int sep = this.separators.get(this.separators.size() - 1);
        StringBuilder fsb = new StringBuilder(16);
        fsb.appendCodePoint(sep);
        return fsb.toString();
    }
}

