/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli.command;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.cli.AbstractRootCommandLineParameterHandler;
import org.jkiss.dbeaver.model.cli.CLIException;
import org.jkiss.dbeaver.model.cli.CLIProcessResult;
import org.jkiss.dbeaver.model.cli.CLIUtils;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderRegistry;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWHandlerRegistry;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="network-handlers", description={"List available database network handlers."})
public class ListNetworkHandlersParameterHandler
extends AbstractRootCommandLineParameterHandler {
    @CommandLine.Option(names={"--driver"}, arity="1", description={"List supported handlers for the specified driver."})
    @NotNull
    private String driverId;

    @Override
    public void run() throws CLIException {
        DBPDataSourceProviderRegistry driverRegistry = DBWorkbench.getPlatform().getDataSourceProviderRegistry();
        DBWHandlerRegistry networkHandlerRegistry = DBWorkbench.getPlatform().getNetworkHandlerRegistry();
        StringBuilder output = new StringBuilder();
        if (CommonUtils.isNotEmpty((String)this.driverId)) {
            DBPDriver driver = driverRegistry.findDriver(this.driverId);
            if (driver == null) {
                throw new CLIException("Driver '" + this.driverId + "' not found", 2);
            }
            this.oneDriverHelp(driver, networkHandlerRegistry, output);
        } else {
            this.allDriversHelp(driverRegistry, networkHandlerRegistry, output);
        }
        this.context().addResult(output.toString());
        this.context().setPostAction(CLIProcessResult.PostAction.SHUTDOWN);
    }

    private void oneDriverHelp(@NotNull DBPDriver driver, @NotNull DBWHandlerRegistry networkHandlerRegistry, @NotNull StringBuilder output) {
        List networkHandlers = networkHandlerRegistry.getDescriptors(driver);
        output.append("Network handlers for driver '").append(driver.getName()).append("'\n");
        for (DBWHandlerDescriptor handler : networkHandlers) {
            output.append("Network Handler ID: ").append(handler.getId()).append(", Name: ").append(handler.getCodeName()).append(", Description: ").append(handler.getDescription());
            if (!ArrayUtils.isEmpty((Object[])handler.getHandlerProperties())) {
                output.append(", Parameters:");
            }
            String prefix = handler.getPrefix() + ".";
            for (DBPPropertyDescriptor property : handler.getHandlerProperties()) {
                String helpText = CLIUtils.getPropertyHelpText(property, prefix);
                output.append(helpText);
            }
            output.append("\n");
        }
        output.replace(output.length() - 2, output.length(), "");
    }

    private void allDriversHelp(@NotNull DBPDataSourceProviderRegistry driverRegistry, @NotNull DBWHandlerRegistry networkHandlerRegistry, @NotNull StringBuilder output) {
        HashMap<String, Set> driversByHandler = new HashMap<String, Set>();
        List providers = driverRegistry.getDataSourceProviders();
        for (DBPDataSourceProviderDescriptor dBPDataSourceProviderDescriptor : providers) {
            for (DBPDriver driver : dBPDataSourceProviderDescriptor.getDrivers()) {
                List networkHandlers = networkHandlerRegistry.getDescriptors(driver);
                for (DBWHandlerDescriptor networkHandler : networkHandlers) {
                    driversByHandler.computeIfAbsent(networkHandler.getId(), k -> new HashSet()).add(driver.getId());
                }
            }
        }
        output.append("Available network handlers:\n");
        for (Map.Entry entry : driversByHandler.entrySet()) {
            String handlerId = (String)entry.getKey();
            DBWHandlerDescriptor handler = networkHandlerRegistry.getDescriptor(handlerId);
            String prefix = handler.getPrefix() + ".";
            Set driverIds = (Set)entry.getValue();
            output.append("Network Handler ID: ").append(handlerId).append(", Name: ").append(handler.getCodeName()).append(", Description: ").append(handler.getDescription());
            if (!ArrayUtils.isEmpty((Object[])handler.getHandlerProperties())) {
                output.append(", Parameters:");
            }
            output.append("\n").append("Supported by drivers: ").append(String.join((CharSequence)", ", driverIds)).append("\n");
            for (DBPPropertyDescriptor property : handler.getHandlerProperties()) {
                String helpText = CLIUtils.getPropertyHelpText(property, prefix);
                output.append(helpText);
            }
            output.append("\n");
        }
        output.replace(output.length() - 2, output.length(), "");
    }
}

