/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.handler;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainer;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainerOptions;
import org.jkiss.dbeaver.ui.controls.resultset.handler.CopyAsConfigurationStorage;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;

class CopyAsConfigurationDialog
extends BaseDialog {
    private static final Log log = Log.getLog(CopyAsConfigurationDialog.class);
    private final Map<DataTransferProcessorDescriptor, Map<String, Object>> propertiesMap = CopyAsConfigurationStorage.getProcessorProperties();
    private final IResultSetController resultSetController;
    private TableViewer processorsTable;
    private PropertyTreeViewer propertyEditor;
    private PropertySourceCustom propertySource;
    private DataTransferProcessorDescriptor selectedProcessor;

    CopyAsConfigurationDialog(IResultSetController resultSetController) {
        super(UIUtils.getActiveShell(), ResultSetMessages.dialog_copy_as_configuration_name, null);
        this.resultSetController = resultSetController;
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        this.createButton(parent, 0, IDialogConstants.PROCEED_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected Composite createDialogArea(@NotNull Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        SashForm sash = new SashForm(dialogArea, 256);
        sash.setLayoutData((Object)new GridData(1808));
        this.createNodesTable((Composite)sash);
        this.propertyEditor = new PropertyTreeViewer((Composite)sash, 2048);
        ResultSetDataContainerOptions options = new ResultSetDataContainerOptions();
        ResultSetDataContainer dataContainer = new ResultSetDataContainer(this.resultSetController, options);
        List model = DataTransferRegistry.getInstance().getAvailableConsumers(Collections.singleton(dataContainer)).stream().flatMap(node -> Arrays.stream(node.getProcessors())).filter(processor -> !processor.isBinaryFormat()).sorted(Comparator.comparing(DataTransferProcessorDescriptor::getName)).collect(Collectors.toList());
        if (!model.isEmpty()) {
            this.processorsTable.setInput(model);
            this.selectedProcessor = (DataTransferProcessorDescriptor)model.get(0);
            this.processorsTable.setSelection((ISelection)new StructuredSelection((Object)this.selectedProcessor));
            this.showPropertiesForSelectedProcessor();
        } else {
            log.debug((Object)"No appropriate descriptor found, nothing to add to the configure page");
        }
        UIUtils.maxTableColumnsWidth((Table)this.processorsTable.getTable());
        sash.setWeights(new int[]{50, 50});
        return dialogArea;
    }

    private void createNodesTable(@NotNull Composite composite) {
        Composite panel = UIUtils.createComposite((Composite)composite, (int)1);
        this.processorsTable = new TableViewer(panel, 67588);
        this.processorsTable.getTable().setLayoutData((Object)new GridData(1808));
        this.processorsTable.getTable().setLinesVisible(true);
        this.processorsTable.setContentProvider((IContentProvider)new IStructuredContentProvider(this){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        CellLabelProvider labelProvider = new CellLabelProvider(this){

            public void update(ViewerCell cell) {
                DataTransferProcessorDescriptor processorDescriptor = (DataTransferProcessorDescriptor)cell.getElement();
                if (processorDescriptor == null) {
                    log.debug((Object)"Unable to provide label for cell: cell's element is null");
                    return;
                }
                if (cell.getColumnIndex() == 0) {
                    cell.setImage(DBeaverIcons.getImage((DBPImage)processorDescriptor.getIcon()));
                    cell.setText(processorDescriptor.getName());
                } else {
                    cell.setText(processorDescriptor.getDescription());
                }
            }
        };
        TableViewerColumn columnName = new TableViewerColumn(this.processorsTable, 16384);
        columnName.setLabelProvider(labelProvider);
        columnName.getColumn().setText("");
        TableViewerColumn columnDesc = new TableViewerColumn(this.processorsTable, 16384);
        columnDesc.setLabelProvider(labelProvider);
        columnDesc.getColumn().setText("");
        this.processorsTable.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CopyAsConfigurationDialog.this.propertiesMap.put(CopyAsConfigurationDialog.this.selectedProcessor, CopyAsConfigurationDialog.this.propertySource.getPropertiesWithDefaults());
                TableItem tableItem = (TableItem)e.item;
                CopyAsConfigurationDialog.this.selectedProcessor = (DataTransferProcessorDescriptor)tableItem.getData();
                CopyAsConfigurationDialog.this.showPropertiesForSelectedProcessor();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void buttonPressed(int buttonId) {
        this.propertyEditor.saveEditorValues();
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.propertiesMap.put(this.selectedProcessor, this.propertySource.getPropertiesWithDefaults());
        try {
            CopyAsConfigurationStorage.saveProcessorProperties(this.propertiesMap);
        }
        catch (IOException e) {
            DBWorkbench.getPlatformUI().showError(ResultSetMessages.dialog_copy_as_configuration_error_saving_processor_properties_title, ResultSetMessages.dialog_copy_as_configuration_error_saving_processor_properties_message, (Throwable)e);
        }
        super.okPressed();
    }

    private void showPropertiesForSelectedProcessor() {
        Map properties = this.propertiesMap.computeIfAbsent(this.selectedProcessor, proc -> new HashMap());
        this.propertySource = new PropertySourceCustom(this.selectedProcessor.getProperties(), properties);
        this.propertyEditor.loadProperties((DBPPropertySource)this.propertySource);
    }
}

