/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.function.BiConsumer;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.CompositeBorderPainter;
import org.jkiss.dbeaver.ui.UIUtils;

public abstract class HoverControlSupport<T extends Control> {
    private final T target;
    private Control overlay;
    private boolean hovering;

    public HoverControlSupport(@NotNull T target) {
        this.target = target;
        Display display = target.getDisplay();
        Listener filter = event -> {
            boolean nowHovering = this.isHoveringTarget(event);
            if (nowHovering != this.hovering) {
                this.hovering = nowHovering;
                this.onHoverChange(nowHovering);
            }
        };
        display.addFilter(5, filter);
        target.addDisposeListener(e -> {
            this.onHoverChange(false);
            display.removeFilter(5, filter);
        });
    }

    public static <T extends Control> void install(@NotNull T target, final @NotNull BiConsumer<Composite, T> creator) {
        new HoverControlSupport<T>(target){

            @Override
            protected void createControl(@NotNull Composite parent, @NotNull T target) {
                creator.accept(parent, target);
            }
        };
    }

    protected abstract void createControl(@NotNull Composite var1, @NotNull T var2);

    protected void dispose() {
    }

    @NotNull
    protected Composite createOverlayControl(@NotNull Composite parent, @NotNull T target) {
        Composite holder = new Composite(parent, 0);
        holder.setLayout((Layout)RowLayoutFactory.fillDefaults().margins(1, 1).spacing(5).wrap(false).create());
        new CompositeBorderPainter((Control)holder);
        this.createControl(holder, target);
        return holder;
    }

    @NotNull
    protected Point pickOverlayLocation(@NotNull T target, @NotNull Point size) {
        Control origin = this.pickOverlayControl(target);
        Rectangle bounds = origin.getBounds();
        Point location = target.getShell().toControl(origin.toDisplay(new Point(0, 0)));
        location.x += bounds.width - size.x - 5;
        location.y += bounds.height - size.y - 5;
        return location;
    }

    @NotNull
    protected Control pickOverlayControl(@NotNull T target) {
        return target;
    }

    private void onHoverChange(boolean hovering) {
        if (this.overlay != null) {
            this.dispose();
            this.overlay.dispose();
            this.overlay = null;
        }
        if (!hovering) {
            return;
        }
        Composite holder = this.createOverlayControl((Composite)this.target.getShell(), this.target);
        Point size = holder.computeSize(-1, -1);
        Point location = this.pickOverlayLocation(this.target, size);
        holder.setSize(size);
        holder.setLocation(location);
        holder.moveAbove(null);
        this.overlay = holder;
    }

    private boolean isHoveringTarget(@NotNull Event event) {
        Control control;
        if (this.target.isDisposed() || !this.target.isVisible()) {
            return false;
        }
        if (!(event.widget instanceof Control) || (control = (Control)event.widget).isDisposed()) {
            return false;
        }
        Point targetLocation = this.target.toDisplay(0, 0);
        Point targetSize = this.target.getSize();
        Rectangle targetBounds = new Rectangle(targetLocation.x, targetLocation.y, targetSize.x, targetSize.y);
        Point eventLocation = control.toDisplay(event.x, event.y);
        if (!targetBounds.contains(eventLocation)) {
            return false;
        }
        return UIUtils.isParent(this.target, control) || UIUtils.isParent(this.overlay, control);
    }
}

