/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.undo.snapshot;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.undo.snapshot.IMarkerSnapshot;
import org.eclipse.core.runtime.CoreException;

public class MarkerSnapshot
implements IMarkerSnapshot {
    String type;
    Map<String, Object> attributes;
    IResource resource;

    public MarkerSnapshot(IMarker marker) throws CoreException {
        this.type = marker.getType();
        this.attributes = marker.getAttributes();
        this.resource = marker.getResource();
    }

    public MarkerSnapshot(String type, Map<String, Object> attributes, IResource resource) {
        this.type = type;
        this.attributes = attributes;
        this.resource = resource;
    }

    @Override
    public IMarker createMarker() throws CoreException {
        IMarker marker = this.resource.createMarker(this.type);
        marker.setAttributes(this.attributes);
        return marker;
    }

    @Override
    public void updateMarker(IMarker marker) throws CoreException {
        marker.setAttributes(this.attributes);
    }

    @Override
    public IResource getResource() {
        return this.resource;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

