/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.task;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.utils.CommonUtils;

public interface DBTTaskInfoCollector {
    public void collectTaskInfo(@NotNull DBTTask var1, @NotNull TaskInformation var2);

    public static class TaskInformation {
        private final Set<DBPDataSourceContainer> dataSources = new LinkedHashSet<DBPDataSourceContainer>();
        private final Set<String> ioLocations = new LinkedHashSet<String>();
        private final Set<String> inetAddresses = new LinkedHashSet<String>();

        @NotNull
        public Collection<DBPDataSourceContainer> getDataSources() {
            return this.dataSources;
        }

        @NotNull
        public Collection<String> getIOLocations() {
            return this.ioLocations;
        }

        @NotNull
        public Collection<String> getInetAddresses() {
            return this.inetAddresses;
        }

        public void addDataSource(@Nullable DBPDataSourceContainer ds) {
            if (ds != null) {
                this.dataSources.add(ds);
            }
        }

        public void addLocation(@Nullable String pathOrURI) {
            if (!CommonUtils.isEmpty((String)pathOrURI)) {
                this.ioLocations.add(pathOrURI);
            }
        }

        public void addInetAddress(@Nullable String hostOrIp) {
            if (!CommonUtils.isEmpty((String)hostOrIp)) {
                this.inetAddresses.add(hostOrIp);
            }
        }
    }
}

