/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.AbstractTransferDragSourceListener;
import org.eclipse.gef.ui.parts.TreeViewerTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

class TreeViewerTransferDragListener
extends AbstractTransferDragSourceListener {
    private List<Object> modelSelection;

    public TreeViewerTransferDragListener(EditPartViewer viewer) {
        super(viewer, (Transfer)TreeViewerTransfer.getInstance());
    }

    @Deprecated(since="3.0", forRemoval=true)
    public TreeViewerTransferDragListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.getViewer().getSelectedEditParts();
    }

    @Override
    public void dragStart(DragSourceEvent event) {
        TreeViewerTransfer.getInstance().setViewer(this.getViewer());
        List<? extends EditPart> selection = this.getViewer().getSelectedEditParts();
        TreeViewerTransfer.getInstance().setObject(selection);
        this.saveModelSelection(selection);
    }

    @Override
    public void dragFinished(DragSourceEvent event) {
        TreeViewerTransfer.getInstance().setObject(null);
        TreeViewerTransfer.getInstance().setViewer(null);
        if (event.doit) {
            this.revertModelSelection();
        } else {
            this.modelSelection = null;
        }
    }

    protected void revertModelSelection() {
        List<EditPart> list = this.modelSelection.stream().map(m -> this.getViewer().getEditPartForModel(m)).toList();
        this.getViewer().setSelection((ISelection)new StructuredSelection(list));
        this.modelSelection = null;
    }

    protected void saveModelSelection(List<? extends EditPart> editPartSelection) {
        this.modelSelection = editPartSelection.stream().map(EditPart::getModel).toList();
    }
}

