/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.notifications;

import java.util.function.Function;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.notifications.AbstractNotificationPopup;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NotificationPopup
extends AbstractNotificationPopup {
    private Function<Composite, ? extends Control> contentCreator;
    private Function<Composite, Control> titleCreator;
    private boolean hasCloseButton;
    private Image titleImage;

    public static Builder forDisplay(Display display) {
        return new Builder(display);
    }

    public static Builder forShell(Shell shell) {
        return new Builder(shell.getDisplay()).shell(shell);
    }

    private NotificationPopup(Builder builder) {
        super(builder.display);
        this.contentCreator = builder.contentCreator;
        this.titleCreator = builder.titleCreator;
        this.hasCloseButton = builder.hasCloseButton;
        this.titleImage = builder.titleImage;
        if (builder.delay != null) {
            this.setDelayClose(builder.delay);
        }
        if (builder.fadeIn != null) {
            this.setFadingEnabled(builder.fadeIn);
        }
        if (builder.shell != null) {
            this.setParentShell(builder.shell);
        }
    }

    @Override
    protected void createTitleArea(Composite parent) {
        Control control;
        if (this.titleCreator == null) {
            super.createTitleArea(parent);
            return;
        }
        ((GridData)parent.getLayoutData()).heightHint = 24;
        int numColums = 1;
        if (this.hasCloseButton) {
            ++numColums;
        }
        if (this.titleImage != null) {
            ++numColums;
        }
        GridLayoutFactory.fillDefaults().numColumns(numColums).applyTo(parent);
        if (this.titleImage != null) {
            WidgetFactory.label((int)0).image(this.titleImage);
        }
        if ((control = this.titleCreator.apply(parent)).getLayoutData() == null) {
            GridDataFactory.fillDefaults().grab(true, false).applyTo(control);
        }
        control.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        control.setForeground(this.getTitleForeground());
        control.setCursor(parent.getDisplay().getSystemCursor(21));
        if (this.hasCloseButton) {
            super.createCloseButton(parent);
        }
    }

    @Override
    protected void createContentArea(Composite parent) {
        if (this.contentCreator == null) {
            super.createContentArea(parent);
            return;
        }
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Control control = this.contentCreator.apply(parent);
        if (control.getLayoutData() == null) {
            GridDataFactory.fillDefaults().grab(true, false).applyTo(control);
        }
    }

    public static class Builder {
        private Display display;
        private Function<Composite, Control> contentCreator;
        private Function<Composite, Control> titleCreator;
        private Long delay;
        private Boolean fadeIn;
        private boolean hasCloseButton;
        private Image titleImage;
        private Shell shell;

        private Builder(Display display) {
            this.display = display;
        }

        private Builder shell(Shell shell) {
            this.shell = shell;
            return this;
        }

        public Builder content(Function<Composite, Control> contentCreator) {
            this.contentCreator = contentCreator;
            return this;
        }

        public Builder text(String text) {
            return this.content(arg_0 -> ((LabelFactory)WidgetFactory.label((int)0).text(text)).create(arg_0));
        }

        public Builder title(Function<Composite, Control> titleCreator, boolean hasCloseButton) {
            this.titleCreator = titleCreator;
            this.hasCloseButton = hasCloseButton;
            return this;
        }

        public Builder title(String title, boolean hasCloseButton) {
            return this.title(arg_0 -> ((LabelFactory)WidgetFactory.label((int)0).text(title)).create(arg_0), hasCloseButton);
        }

        public Builder titleImage(Image image) {
            this.titleImage = image;
            return this;
        }

        public Builder delay(long delay) {
            this.delay = delay;
            return this;
        }

        public Builder fadeIn(boolean fadeIn) {
            this.fadeIn = fadeIn;
            return this;
        }

        public int open() {
            return this.build().open();
        }

        public NotificationPopup build() {
            return new NotificationPopup(this);
        }
    }
}

