/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.copilot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.annotations.SerializedName;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseChunk;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseConsumer;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotChatChunk;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotChatRequest;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotChatResponse;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotModel;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotModelList;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotSessionToken;
import org.jkiss.dbeaver.model.ai.utils.AIHttpUtils;
import org.jkiss.dbeaver.model.ai.utils.MonitoredHttpClient;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class CopilotClient
implements AutoCloseable {
    private static final String DATA_EVENT = "data: ";
    private static final String DONE_EVENT = "[DONE]";
    private static final Duration TIMEOUT = Duration.ofSeconds(30L);
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).serializeNulls().create();
    private static final String COPILOT_SESSION_TOKEN_URL = "https://api.github.com/copilot_internal/v2/token";
    private static final String CHAT_REQUEST_URL = "https://api.githubcopilot.com/chat/completions";
    private static final String COPILOT_CHAT_MODELS_URL = "https://api.githubcopilot.com/models";
    private static final String EDITOR_VERSION = "Neovim/0.6.1";
    private static final String EDITOR_PLUGIN_VERSION = "copilot.vim/1.16.0";
    private static final String USER_AGENT = "GithubCopilot/1.155.0";
    private static final String CHAT_EDITOR_VERSION = "vscode/1.80.1";
    private static final String DBEAVER_OAUTH_APP = "Iv1.b507a08c87ecfe98";
    private final MonitoredHttpClient client = new MonitoredHttpClient(HttpClient.newBuilder().build());
    private static Map<String, CopilotModel> models = new LinkedHashMap<String, CopilotModel>();

    public DeviceCodeResponse requestDeviceCode(@NotNull DBRProgressMonitor monitor) throws DBException {
        DeviceCodeRequest deviceCodeRequest = new DeviceCodeRequest(DBEAVER_OAUTH_APP, "read:user");
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve("https://github.com/login/device/code", new String[0])).header("accept", "application/json").header("content-type", "application/json").timeout(Duration.ofSeconds(10L)).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)deviceCodeRequest))).build();
        HttpResponse<String> response = this.client.send(monitor, request);
        if (response.statusCode() == 200) {
            return (DeviceCodeResponse)GSON.fromJson(response.body(), DeviceCodeResponse.class);
        }
        throw CopilotClient.mapHttpError(response);
    }

    @NotNull
    public String requestAccessToken(@NotNull DBRProgressMonitor monitor, @NotNull DeviceCodeResponse deviceCodeResponse, @NotNull Future<?> cancellationToken) throws DBException, InterruptedException {
        AccessTokenRequest accessTokenRequest = new AccessTokenRequest(DBEAVER_OAUTH_APP, deviceCodeResponse.deviceCode(), "urn:ietf:params:oauth:grant-type:device_code");
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve("https://github.com/login/oauth/access_token", new String[0])).header("accept", "application/json").header("content-type", "application/json").timeout(Duration.ofSeconds(5L)).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)accessTokenRequest))).build();
        Duration expiresIn = Duration.ofSeconds(deviceCodeResponse.expiresIn());
        Duration interval = Duration.ofSeconds(deviceCodeResponse.interval());
        Instant start = Instant.now();
        while (Instant.now().isBefore(start.plus(expiresIn)) && !monitor.isCanceled() && !cancellationToken.isCancelled()) {
            HttpResponse<String> response = this.client.send(monitor, request);
            if (response.statusCode() != 200) {
                throw CopilotClient.mapHttpError(response);
            }
            AccessTokenResponse body = (AccessTokenResponse)GSON.fromJson(response.body(), AccessTokenResponse.class);
            if (CommonUtils.isNotEmpty((String)body.accessToken())) {
                return body.accessToken();
            }
            switch (body.error()) {
                case "authorization_pending": {
                    Thread.sleep(interval.toMillis());
                    break;
                }
                case "slow_down": {
                    Thread.sleep(interval.plusSeconds(5L).toMillis());
                    break;
                }
                default: {
                    throw new DBException("Error requesting access token: " + body.error());
                }
            }
        }
        if (monitor.isCanceled() || cancellationToken.isCancelled()) {
            throw new DBException("Access token request was canceled by the user");
        }
        throw new DBException("Access token request timed out");
    }

    @NotNull
    public CopilotSessionToken requestSessionToken(DBRProgressMonitor monitor, String accessToken) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(COPILOT_SESSION_TOKEN_URL, new String[0])).header("authorization", "token " + accessToken).header("editor-version", EDITOR_VERSION).header("editor-plugin-version", EDITOR_PLUGIN_VERSION).header("User-Agent", USER_AGENT).GET().timeout(TIMEOUT).build();
        HttpResponse<String> response = this.client.send(monitor, request);
        if (response.statusCode() == 200) {
            return (CopilotSessionToken)GSON.fromJson(response.body(), CopilotSessionToken.class);
        }
        throw CopilotClient.mapHttpError(response);
    }

    public CopilotChatResponse chat(DBRProgressMonitor monitor, String token, CopilotChatRequest chatRequest) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(CHAT_REQUEST_URL, new String[0])).header("Content-type", "application/json").header("authorization", "Bearer " + token).header("Editor-Version", CHAT_EDITOR_VERSION).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)chatRequest))).timeout(TIMEOUT).build();
        HttpResponse<String> response = this.client.send(monitor, request);
        if (response.statusCode() == 200) {
            return (CopilotChatResponse)GSON.fromJson(response.body(), CopilotChatResponse.class);
        }
        throw CopilotClient.mapHttpError(response);
    }

    public void createChatCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull String token, @NotNull CopilotChatRequest chatRequest, @NotNull AIEngineResponseConsumer listener) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(CHAT_REQUEST_URL, new String[0])).header("Content-type", "application/json").header("authorization", "Bearer " + token).header("Editor-Version", CHAT_EDITOR_VERSION).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)chatRequest))).timeout(TIMEOUT).build();
        this.client.sendAsync(request, line -> {
            if (line.startsWith(DATA_EVENT)) {
                String data = line.substring(6).trim();
                if (DONE_EVENT.equals(data)) {
                    listener.close();
                } else {
                    try {
                        CopilotChatChunk chunk = (CopilotChatChunk)GSON.fromJson(data, CopilotChatChunk.class);
                        List<String> choices = chunk.choices().stream().takeWhile(it -> it.delta().content() != null).map(it -> it.delta().content()).toList();
                        listener.nextChunk(new AIEngineResponseChunk(choices));
                    }
                    catch (Exception e) {
                        listener.error(e);
                    }
                }
            }
        }, listener::error, listener::close);
    }

    public static List<String> getModels(@NotNull DBRProgressMonitor monitor, @Nullable String token, boolean forceRefresh) {
        if ((models.isEmpty() || forceRefresh) && CommonUtils.isNotEmpty((String)token)) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (CopilotClient copilotClient = new CopilotClient();){
                    List<CopilotModel> copilotModelList = copilotClient.loadModels(monitor, token);
                    models = copilotModelList.stream().collect(LinkedHashMap::new, (map, model) -> {
                        CopilotModel copilotModel = map.put(model.id(), model);
                    }, HashMap::putAll);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                DBWorkbench.getPlatformUI().showError("Error reading model list", "Failed to read Copilot model list", (Throwable)ex);
            }
        }
        if (models.isEmpty()) {
            return List.of();
        }
        return models.keySet().stream().toList();
    }

    public List<CopilotModel> loadModels(@NotNull DBRProgressMonitor monitor, @NotNull String token) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().uri(AIHttpUtils.resolve(COPILOT_CHAT_MODELS_URL, new String[0])).header("Content-type", "application/json").header("authorization", "Bearer " + token).header("Editor-Version", CHAT_EDITOR_VERSION).GET().timeout(TIMEOUT).build();
        HttpResponse<String> response = this.client.send(monitor, request);
        if (response.statusCode() == 200) {
            CopilotModelList copilotModels = (CopilotModelList)GSON.fromJson(response.body(), CopilotModelList.class);
            return copilotModels.data().stream().filter(CopilotModel::isEnabled).toList();
        }
        throw new DBException("Request failed: status=" + response.statusCode() + ", body=" + response.body());
    }

    @Override
    public void close() {
        this.client.close();
    }

    private static DBException mapHttpError(HttpResponse<String> response) {
        return new DBException("HTTP error: " + response.statusCode() + " " + response.body());
    }

    private record AccessTokenRequest(@SerializedName(value="client_id") String clientId, @SerializedName(value="device_code") String deviceCode, @SerializedName(value="grant_type") String grantType) {
    }

    private record AccessTokenResponse(@SerializedName(value="error") String error, @SerializedName(value="access_token") String accessToken) {
    }

    private record DeviceCodeRequest(@SerializedName(value="client_id") String clientId, @SerializedName(value="scope") String scope) {
    }

    public record DeviceCodeResponse(@SerializedName(value="device_code") String deviceCode, @SerializedName(value="user_code") String userCode, @SerializedName(value="verification_uri") String verificationUri, @SerializedName(value="expires_in") int expiresIn, @SerializedName(value="interval") int interval) {
    }
}

