﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/wellarchitected/WellArchitectedRequest.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace WellArchitected {
namespace Model {

/**
 */
class ExportLensRequest : public WellArchitectedRequest {
 public:
  AWS_WELLARCHITECTED_API ExportLensRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ExportLens"; }

  AWS_WELLARCHITECTED_API Aws::String SerializePayload() const override;

  AWS_WELLARCHITECTED_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{

  inline const Aws::String& GetLensAlias() const { return m_lensAlias; }
  inline bool LensAliasHasBeenSet() const { return m_lensAliasHasBeenSet; }
  template <typename LensAliasT = Aws::String>
  void SetLensAlias(LensAliasT&& value) {
    m_lensAliasHasBeenSet = true;
    m_lensAlias = std::forward<LensAliasT>(value);
  }
  template <typename LensAliasT = Aws::String>
  ExportLensRequest& WithLensAlias(LensAliasT&& value) {
    SetLensAlias(std::forward<LensAliasT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The lens version to be exported.</p>
   */
  inline const Aws::String& GetLensVersion() const { return m_lensVersion; }
  inline bool LensVersionHasBeenSet() const { return m_lensVersionHasBeenSet; }
  template <typename LensVersionT = Aws::String>
  void SetLensVersion(LensVersionT&& value) {
    m_lensVersionHasBeenSet = true;
    m_lensVersion = std::forward<LensVersionT>(value);
  }
  template <typename LensVersionT = Aws::String>
  ExportLensRequest& WithLensVersion(LensVersionT&& value) {
    SetLensVersion(std::forward<LensVersionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_lensAlias;

  Aws::String m_lensVersion;
  bool m_lensAliasHasBeenSet = false;
  bool m_lensVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace WellArchitected
}  // namespace Aws
