﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/logs/CloudWatchLogs_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace CloudWatchLogs
{
namespace Model
{
  enum class FlattenedElement
  {
    NOT_SET,
    first,
    last
  };

namespace FlattenedElementMapper
{
AWS_CLOUDWATCHLOGS_API FlattenedElement GetFlattenedElementForName(const Aws::String& name);

AWS_CLOUDWATCHLOGS_API Aws::String GetNameForFlattenedElement(FlattenedElement value);
} // namespace FlattenedElementMapper
} // namespace Model
} // namespace CloudWatchLogs
} // namespace Aws
