#
# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################
"""
The arg spec for the junos_bgp_global module
"""
from __future__ import absolute_import, division, print_function


__metaclass__ = type


class Bgp_globalArgs(object):  # pylint: disable=R0903
    """The arg spec for the junos_bgp_global module"""

    def __init__(self, **kwargs):
        pass

    argument_spec = {
        "config": {
            "options": {
                "accept_remote_nexthop": {"type": "bool"},
                "add_path_display_ipv4_address": {"type": "bool"},
                "advertise_bgp_static": {
                    "options": {
                        "policy": {"type": "str"},
                        "set": {"type": "bool"},
                    },
                    "type": "dict",
                },
                "advertise_external": {
                    "options": {
                        "conditional": {"type": "bool"},
                        "set": {"type": "bool"},
                    },
                    "type": "dict",
                },
                "advertise_from_main_vpn_tables": {"type": "bool"},
                "advertise_inactive": {"type": "bool"},
                "advertise_peer_as": {"type": "bool"},
                "as_number": {"type": "str"},
                "asdot_notation": {"type": "bool"},
                "authentication_algorithm": {
                    "choices": ["aes-128-cmac-96", "hmac-sha-1-96", "md5"],
                    "type": "str",
                },
                "authentication_key": {"type": "str", "no_log": True},
                "authentication_key_chain": {"type": "str", "no_log": False},
                "bfd_liveness_detection": {
                    "options": {
                        "authentication": {
                            "options": {
                                "algorithm": {
                                    "choices": [
                                        "keyed-md5",
                                        "keyed-sha-1",
                                        "meticulous-keyed-md5",
                                        "meticulous-keyed-sha-1",
                                        "simple-password",
                                    ],
                                    "type": "str",
                                },
                                "key_chain": {"type": "str", "no_log": True},
                                "loose_check": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "detection_time": {
                            "options": {"threshold": {"type": "int"}},
                            "type": "dict",
                        },
                        "holddown_interval": {"type": "int"},
                        "minimum_interval": {"type": "int"},
                        "minimum_receive_interval": {"type": "int"},
                        "multiplier": {"type": "int"},
                        "no_adaptation": {"type": "bool"},
                        "session_mode": {
                            "choices": ["automatic", "multihop", "single-hop"],
                            "type": "str",
                        },
                        "transmit_interval": {
                            "options": {
                                "minimum_interval": {"type": "int"},
                                "threshold": {"type": "int"},
                            },
                            "type": "dict",
                        },
                        "version": {
                            "choices": ["0", "1", "automatic"],
                            "type": "str",
                        },
                    },
                    "type": "dict",
                },
                "bgp_error_tolerance": {
                    "options": {
                        "malformed_route_limit": {"type": "int"},
                        "malformed_update_log_interval": {"type": "int"},
                        "no_malformed_route_limit": {"type": "bool"},
                        "set": {"type": "bool"},
                    },
                    "type": "dict",
                },
                "bmp": {
                    "options": {
                        "monitor": {"type": "bool"},
                        "route_monitoring": {
                            "options": {
                                "none": {"type": "bool"},
                                "post_policy": {"type": "bool"},
                                "post_policy_exclude_non_eligible": {
                                    "type": "bool",
                                },
                                "post_policy_exclude_non_feasible": {
                                    "type": "bool",
                                },
                                "pre_policy": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                    },
                    "type": "dict",
                },
                "cluster_id": {"type": "str"},
                "damping": {"type": "bool"},
                "description": {"type": "str"},
                "disable": {"type": "bool"},
                "egress_te": {
                    "options": {
                        "backup_path": {"type": "str"},
                        "set": {"type": "bool"},
                    },
                    "type": "dict",
                },
                "egress_te_backup_paths": {
                    "options": {
                        "templates": {
                            "elements": "dict",
                            "options": {
                                "ip_forward": {
                                    "options": {
                                        "rti_name": {"type": "str"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "path_name": {"required": True, "type": "str"},
                                "peers": {"elements": "str", "type": "list"},
                                "remote_nexthop": {"type": "str"},
                            },
                            "type": "list",
                        },
                    },
                    "type": "dict",
                },
                "egress_te_set_segment": {
                    "elements": "dict",
                    "options": {
                        "egress_te_backup_segment_label": {"type": "int"},
                        "label": {"type": "int"},
                        "name": {"required": True, "type": "str"},
                    },
                    "type": "list",
                },
                "egress_te_sid_stats": {"type": "bool"},
                "enforce_first_as": {"type": "bool"},
                "export": {"type": "str"},
                "forwarding_context": {"type": "str"},
                "graceful_restart": {
                    "options": {
                        "disable": {"type": "bool"},
                        "dont_help_shared_fate_bfd_down": {"type": "bool"},
                        "forwarding_state_bit": {
                            "options": {
                                "as_rr_client": {"type": "bool"},
                                "from_fib": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "long_lived": {
                            "options": {
                                "advertise_to_non_llgr_neighbor": {
                                    "options": {
                                        "omit_no_export": {"type": "bool"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "receiver_disable": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "restart_time": {"type": "int"},
                        "set": {"type": "bool"},
                        "stale_routes_time": {"type": "int"},
                    },
                    "type": "dict",
                },
                "groups": {
                    "elements": "dict",
                    "options": {
                        "accept_remote_nexthop": {"type": "bool"},
                        "add_path_display_ipv4_address": {"type": "bool"},
                        "advertise_bgp_static": {
                            "options": {
                                "policy": {"type": "str"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "advertise_external": {
                            "options": {
                                "conditional": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "advertise_inactive": {"type": "bool"},
                        "advertise_peer_as": {"type": "bool"},
                        "allow": {"elements": "str", "type": "list"},
                        "as_override": {"type": "bool"},
                        "authentication_algorithm": {
                            "choices": [
                                "aes-128-cmac-96",
                                "hmac-sha-1-96",
                                "md5",
                            ],
                            "type": "str",
                        },
                        "authentication_key": {"type": "str", "no_log": True},
                        "authentication_key_chain": {
                            "type": "str",
                            "no_log": False,
                        },
                        "bfd_liveness_detection": {
                            "options": {
                                "authentication": {
                                    "options": {
                                        "algorithm": {
                                            "choices": [
                                                "keyed-md5",
                                                "keyed-sha-1",
                                                "meticulous-keyed-md5",
                                                "meticulous-keyed-sha-1",
                                                "simple-password",
                                            ],
                                            "type": "str",
                                        },
                                        "key_chain": {
                                            "type": "str",
                                            "no_log": True,
                                        },
                                        "loose_check": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "detection_time": {
                                    "options": {"threshold": {"type": "int"}},
                                    "type": "dict",
                                },
                                "holddown_interval": {"type": "int"},
                                "minimum_interval": {"type": "int"},
                                "minimum_receive_interval": {"type": "int"},
                                "multiplier": {"type": "int"},
                                "no_adaptation": {"type": "bool"},
                                "session_mode": {
                                    "choices": [
                                        "automatic",
                                        "multihop",
                                        "single-hop",
                                    ],
                                    "type": "str",
                                },
                                "transmit_interval": {
                                    "options": {
                                        "minimum_interval": {"type": "int"},
                                        "threshold": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                                "version": {
                                    "choices": ["0", "1", "automatic"],
                                    "type": "str",
                                },
                            },
                            "type": "dict",
                        },
                        "bgp_error_tolerance": {
                            "options": {
                                "malformed_route_limit": {"type": "int"},
                                "malformed_update_log_interval": {
                                    "type": "int",
                                },
                                "no_malformed_route_limit": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "bmp": {
                            "options": {
                                "monitor": {"type": "bool"},
                                "route_monitoring": {
                                    "options": {
                                        "none": {"type": "bool"},
                                        "post_policy": {"type": "bool"},
                                        "post_policy_exclude_non_eligible": {
                                            "type": "bool",
                                        },
                                        "post_policy_exclude_non_feasible": {
                                            "type": "bool",
                                        },
                                        "pre_policy": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "cluster_id": {"type": "str"},
                        "damping": {"type": "bool"},
                        "description": {"type": "str"},
                        "egress_te": {
                            "options": {
                                "backup_path": {"type": "str"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "enforce_first_as": {"type": "bool"},
                        "export": {"type": "str"},
                        "forwarding_context": {"type": "str"},
                        "graceful_restart": {
                            "options": {
                                "disable": {"type": "bool"},
                                "dont_help_shared_fate_bfd_down": {
                                    "type": "bool",
                                },
                                "forwarding_state_bit": {
                                    "options": {
                                        "as_rr_client": {"type": "bool"},
                                        "from_fib": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "long_lived": {
                                    "options": {
                                        "advertise_to_non_llgr_neighbor": {
                                            "options": {
                                                "omit_no_export": {
                                                    "type": "bool",
                                                },
                                                "set": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                        "receiver_disable": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "restart_time": {"type": "int"},
                                "set": {"type": "bool"},
                                "stale_routes_time": {"type": "int"},
                            },
                            "type": "dict",
                        },
                        "hold_time": {"type": "int"},
                        "idle_after_switch_over": {
                            "options": {
                                "forever": {"type": "bool"},
                                "timeout": {"type": "int"},
                            },
                            "type": "dict",
                        },
                        "import": {"elements": "str", "type": "list"},
                        "include_mp_next_hop": {"type": "bool"},
                        "ipsec_sa": {"type": "str"},
                        "keep": {"choices": ["all", "none"], "type": "str"},
                        "local_address": {"type": "str"},
                        "local_as": {
                            "options": {
                                "alias": {"type": "bool"},
                                "as_num": {"required": True, "type": "str"},
                                "loops": {"type": "int"},
                                "no_prepend_global_as": {"type": "bool"},
                                "private": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "local_interface": {"type": "str"},
                        "local_preference": {"type": "str"},
                        "log_updown": {"type": "bool"},
                        "metric_out": {
                            "options": {
                                "igp": {
                                    "options": {
                                        "delay_med_update": {"type": "bool"},
                                        "metric_offset": {"type": "int"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "metric_value": {"type": "int"},
                                "minimum_igp": {
                                    "options": {
                                        "metric_offset": {"type": "int"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "mtu_discovery": {"type": "bool"},
                        "multihop": {
                            "options": {
                                "no_nexthop_change": {"type": "bool"},
                                "set": {"type": "bool"},
                                "ttl": {"type": "int"},
                            },
                            "type": "dict",
                        },
                        "multipath": {
                            "options": {
                                "disable": {"type": "bool"},
                                "multiple_as": {"type": "bool"},
                                "multiple_as_disable": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "name": {"type": "str"},
                        "neighbors": {
                            "elements": "dict",
                            "options": {
                                "accept_remote_nexthop": {"type": "bool"},
                                "add_path_display_ipv4_address": {
                                    "type": "bool",
                                },
                                "advertise_bgp_static": {
                                    "options": {
                                        "policy": {"type": "str"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "advertise_external": {
                                    "options": {
                                        "conditional": {"type": "bool"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "advertise_inactive": {"type": "bool"},
                                "advertise_peer_as": {"type": "bool"},
                                "as_override": {"type": "bool"},
                                "authentication_algorithm": {
                                    "choices": [
                                        "aes-128-cmac-96",
                                        "hmac-sha-1-96",
                                        "md5",
                                    ],
                                    "type": "str",
                                },
                                "authentication_key": {
                                    "type": "str",
                                    "no_log": True,
                                },
                                "authentication_key_chain": {
                                    "type": "str",
                                    "no_log": False,
                                },
                                "bfd_liveness_detection": {
                                    "options": {
                                        "authentication": {
                                            "options": {
                                                "algorithm": {
                                                    "choices": [
                                                        "keyed-md5",
                                                        "keyed-sha-1",
                                                        "meticulous-keyed-md5",
                                                        "meticulous-keyed-sha-1",
                                                        "simple-password",
                                                    ],
                                                    "type": "str",
                                                },
                                                "key_chain": {
                                                    "type": "str",
                                                    "no_log": False,
                                                },
                                                "loose_check": {
                                                    "type": "bool",
                                                },
                                            },
                                            "type": "dict",
                                        },
                                        "detection_time": {
                                            "options": {
                                                "threshold": {"type": "int"},
                                            },
                                            "type": "dict",
                                        },
                                        "holddown_interval": {"type": "int"},
                                        "minimum_interval": {"type": "int"},
                                        "minimum_receive_interval": {
                                            "type": "int",
                                        },
                                        "multiplier": {"type": "int"},
                                        "no_adaptation": {"type": "bool"},
                                        "session_mode": {
                                            "choices": [
                                                "automatic",
                                                "multihop",
                                                "single-hop",
                                            ],
                                            "type": "str",
                                        },
                                        "transmit_interval": {
                                            "options": {
                                                "minimum_interval": {
                                                    "type": "int",
                                                },
                                                "threshold": {"type": "int"},
                                            },
                                            "type": "dict",
                                        },
                                        "version": {
                                            "choices": ["0", "1", "automatic"],
                                            "type": "str",
                                        },
                                    },
                                    "type": "dict",
                                },
                                "bgp_error_tolerance": {
                                    "options": {
                                        "malformed_route_limit": {
                                            "type": "int",
                                        },
                                        "malformed_update_log_interval": {
                                            "type": "int",
                                        },
                                        "no_malformed_route_limit": {
                                            "type": "bool",
                                        },
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "bmp": {
                                    "options": {
                                        "monitor": {"type": "bool"},
                                        "route_monitoring": {
                                            "options": {
                                                "none": {"type": "bool"},
                                                "post_policy": {
                                                    "type": "bool",
                                                },
                                                "post_policy_exclude_non_eligible": {
                                                    "type": "bool",
                                                },
                                                "post_policy_exclude_non_feasible": {
                                                    "type": "bool",
                                                },
                                                "pre_policy": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                    },
                                    "type": "dict",
                                },
                                "cluster_id": {"type": "str"},
                                "damping": {"type": "bool"},
                                "description": {"type": "str"},
                                "egress_te": {
                                    "options": {
                                        "backup_path": {"type": "str"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "enforce_first_as": {"type": "bool"},
                                "export": {"type": "str"},
                                "forwarding_context": {"type": "str"},
                                "graceful_restart": {
                                    "options": {
                                        "disable": {"type": "bool"},
                                        "dont_help_shared_fate_bfd_down": {
                                            "type": "bool",
                                        },
                                        "forwarding_state_bit": {
                                            "options": {
                                                "as_rr_client": {
                                                    "type": "bool",
                                                },
                                                "from_fib": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                        "long_lived": {
                                            "options": {
                                                "advertise_to_non_llgr_neighbor": {
                                                    "options": {
                                                        "omit_no_export": {
                                                            "type": "bool",
                                                        },
                                                        "set": {
                                                            "type": "bool",
                                                        },
                                                    },
                                                    "type": "dict",
                                                },
                                                "receiver_disable": {
                                                    "type": "bool",
                                                },
                                            },
                                            "type": "dict",
                                        },
                                        "restart_time": {"type": "int"},
                                        "set": {"type": "bool"},
                                        "stale_routes_time": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                                "hold_time": {"type": "int"},
                                "idle_after_switch_over": {
                                    "options": {
                                        "forever": {"type": "bool"},
                                        "timeout": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                                "import": {"elements": "str", "type": "list"},
                                "include_mp_next_hop": {"type": "bool"},
                                "ipsec_sa": {"type": "str"},
                                "keep": {
                                    "choices": ["all", "none"],
                                    "type": "str",
                                },
                                "local_address": {"type": "str"},
                                "local_as": {
                                    "options": {
                                        "alias": {"type": "bool"},
                                        "as_num": {
                                            "required": True,
                                            "type": "str",
                                        },
                                        "loops": {"type": "int"},
                                        "no_prepend_global_as": {
                                            "type": "bool",
                                        },
                                        "private": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "local_interface": {"type": "str"},
                                "local_preference": {"type": "str"},
                                "log_updown": {"type": "bool"},
                                "metric_out": {
                                    "options": {
                                        "igp": {
                                            "options": {
                                                "delay_med_update": {
                                                    "type": "bool",
                                                },
                                                "metric_offset": {
                                                    "type": "int",
                                                },
                                                "set": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                        "metric_value": {"type": "int"},
                                        "minimum_igp": {
                                            "options": {
                                                "metric_offset": {
                                                    "type": "int",
                                                },
                                                "set": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                    },
                                    "type": "dict",
                                },
                                "mtu_discovery": {"type": "bool"},
                                "multihop": {
                                    "options": {
                                        "no_nexthop_change": {"type": "bool"},
                                        "set": {"type": "bool"},
                                        "ttl": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                                "multipath": {
                                    "options": {
                                        "disable": {"type": "bool"},
                                        "multiple_as": {"type": "bool"},
                                        "multiple_as_disable": {
                                            "type": "bool",
                                        },
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "neighbor_address": {"type": "str"},
                                "no_advertise_peer_as": {"type": "bool"},
                                "no_aggregator_id": {"type": "bool"},
                                "no_client_reflect": {"type": "bool"},
                                "out_delay": {"type": "int"},
                                "outbound_route_filter": {
                                    "options": {
                                        "bgp_orf_cisco_mode": {"type": "bool"},
                                        "prefix_based": {
                                            "options": {
                                                "accept": {
                                                    "options": {
                                                        "inet": {
                                                            "type": "bool",
                                                        },
                                                        "inet6": {
                                                            "type": "bool",
                                                        },
                                                        "set": {
                                                            "type": "bool",
                                                        },
                                                    },
                                                    "type": "dict",
                                                },
                                                "set": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                    },
                                    "type": "dict",
                                },
                                "passive": {"type": "bool"},
                                "peer_as": {"type": "str"},
                                "preference": {"type": "str"},
                                "remove_private": {
                                    "options": {
                                        "all": {"type": "bool"},
                                        "all_replace": {"type": "bool"},
                                        "all_replace_nearest": {
                                            "type": "bool",
                                        },
                                        "no_peer_loop_check": {"type": "bool"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "rfc6514_compliant_safi129": {"type": "bool"},
                                "route_server_client": {"type": "bool"},
                                "tcp_aggressive_transmission": {
                                    "type": "bool",
                                },
                                "tcp_mss": {"type": "int"},
                                "traceoptions": {
                                    "options": {
                                        "file": {
                                            "options": {
                                                "filename": {
                                                    "required": True,
                                                    "type": "str",
                                                },
                                                "files": {"type": "int"},
                                                "no_world_readable": {
                                                    "type": "bool",
                                                },
                                                "size": {"type": "int"},
                                                "world_readable": {
                                                    "type": "bool",
                                                },
                                            },
                                            "type": "dict",
                                        },
                                        "flag": {
                                            "elements": "dict",
                                            "options": {
                                                "detail": {"type": "bool"},
                                                "disable": {"type": "bool"},
                                                "filter": {
                                                    "options": {
                                                        "match_on_prefix": {
                                                            "type": "bool",
                                                        },
                                                        "policy": {
                                                            "type": "str",
                                                        },
                                                        "set": {
                                                            "type": "bool",
                                                        },
                                                    },
                                                    "type": "dict",
                                                },
                                                "name": {
                                                    "choices": [
                                                        "4byte-as",
                                                        "add-path",
                                                        "all",
                                                        "bfd",
                                                        "damping",
                                                        "egress-te",
                                                        "general",
                                                        "graceful-restart",
                                                        "keepalive",
                                                        "normal",
                                                        "nsr-synchronization",
                                                        "open",
                                                        "packets",
                                                        "policy",
                                                        "refresh",
                                                        "route",
                                                        "state",
                                                        "task",
                                                        "thread-io",
                                                        "thread-update-io",
                                                        "timer",
                                                        "update",
                                                    ],
                                                    "required": True,
                                                    "type": "str",
                                                },
                                                "receive": {"type": "bool"},
                                                "send": {"type": "bool"},
                                            },
                                            "type": "list",
                                        },
                                    },
                                    "type": "dict",
                                },
                                "ttl": {"type": "int"},
                                "unconfigured_peer_graceful_restart": {
                                    "type": "bool",
                                },
                                "vpn_apply_export": {"type": "bool"},
                            },
                            "type": "list",
                        },
                        "no_advertise_peer_as": {"type": "bool"},
                        "no_aggregator_id": {"type": "bool"},
                        "no_client_reflect": {"type": "bool"},
                        "optimal_route_reflection": {
                            "options": {
                                "igp_backup": {"type": "str"},
                                "igp_primary": {"type": "str"},
                            },
                            "type": "dict",
                        },
                        "out_delay": {"type": "int"},
                        "outbound_route_filter": {
                            "options": {
                                "bgp_orf_cisco_mode": {"type": "bool"},
                                "prefix_based": {
                                    "options": {
                                        "accept": {
                                            "options": {
                                                "inet": {"type": "bool"},
                                                "inet6": {"type": "bool"},
                                                "set": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "passive": {"type": "bool"},
                        "peer_as": {"type": "str"},
                        "preference": {"type": "str"},
                        "remove_private": {
                            "options": {
                                "all": {"type": "bool"},
                                "all_replace": {"type": "bool"},
                                "all_replace_nearest": {"type": "bool"},
                                "no_peer_loop_check": {"type": "bool"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "rfc6514_compliant_safi129": {"type": "bool"},
                        "route_server_client": {"type": "bool"},
                        "tcp_aggressive_transmission": {"type": "bool"},
                        "tcp_mss": {"type": "int"},
                        "traceoptions": {
                            "options": {
                                "file": {
                                    "options": {
                                        "filename": {
                                            "required": True,
                                            "type": "str",
                                        },
                                        "files": {"type": "int"},
                                        "no_world_readable": {"type": "bool"},
                                        "size": {"type": "int"},
                                        "world_readable": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "flag": {
                                    "elements": "dict",
                                    "options": {
                                        "detail": {"type": "bool"},
                                        "disable": {"type": "bool"},
                                        "filter": {
                                            "options": {
                                                "match_on_prefix": {
                                                    "type": "bool",
                                                },
                                                "policy": {"type": "str"},
                                                "set": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                        "name": {
                                            "choices": [
                                                "4byte-as",
                                                "add-path",
                                                "all",
                                                "bfd",
                                                "damping",
                                                "egress-te",
                                                "general",
                                                "graceful-restart",
                                                "keepalive",
                                                "normal",
                                                "nsr-synchronization",
                                                "open",
                                                "packets",
                                                "policy",
                                                "refresh",
                                                "route",
                                                "state",
                                                "task",
                                                "thread-io",
                                                "thread-update-io",
                                                "timer",
                                                "update",
                                            ],
                                            "required": True,
                                            "type": "str",
                                        },
                                        "receive": {"type": "bool"},
                                        "send": {"type": "bool"},
                                    },
                                    "type": "list",
                                },
                            },
                            "type": "dict",
                        },
                        "ttl": {"type": "int"},
                        "type": {
                            "choices": ["external", "internal"],
                            "type": "str",
                        },
                        "unconfigured_peer_graceful_restart": {"type": "bool"},
                        "vpn_apply_export": {"type": "bool"},
                    },
                    "type": "list",
                },
                "hold_time": {"type": "int"},
                "holddown_all_stale_labels": {"type": "bool"},
                "idle_after_switch_over": {
                    "options": {
                        "forever": {"type": "bool"},
                        "timeout": {"type": "int"},
                    },
                    "type": "dict",
                },
                "import": {"elements": "str", "type": "list"},
                "include_mp_next_hop": {"type": "bool"},
                "ipsec_sa": {"type": "str"},
                "keep": {"choices": ["all", "none"], "type": "str"},
                "local_address": {"type": "str"},
                "local_as": {
                    "options": {
                        "alias": {"type": "bool"},
                        "as_num": {"required": True, "type": "str"},
                        "loops": {"type": "int"},
                        "no_prepend_global_as": {"type": "bool"},
                        "private": {"type": "bool"},
                    },
                    "type": "dict",
                },
                "local_interface": {"type": "str"},
                "local_preference": {"type": "str"},
                "log_updown": {"type": "bool"},
                "loops": {"type": "int"},
                "metric_out": {
                    "options": {
                        "igp": {
                            "options": {
                                "delay_med_update": {"type": "bool"},
                                "metric_offset": {"type": "int"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "metric_value": {"type": "int"},
                        "minimum_igp": {
                            "options": {
                                "metric_offset": {"type": "int"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                    },
                    "type": "dict",
                },
                "mtu_discovery": {"type": "bool"},
                "multihop": {
                    "options": {
                        "no_nexthop_change": {"type": "bool"},
                        "set": {"type": "bool"},
                        "ttl": {"type": "int"},
                    },
                    "type": "dict",
                },
                "multipath": {
                    "options": {
                        "disable": {"type": "bool"},
                        "multiple_as": {"type": "bool"},
                        "multiple_as_disable": {"type": "bool"},
                        "set": {"type": "bool"},
                    },
                    "type": "dict",
                },
                "multipath_build_priority": {
                    "choices": ["low", "medium"],
                    "type": "str",
                },
                "no_advertise_peer_as": {"type": "bool"},
                "no_aggregator_id": {"type": "bool"},
                "no_client_reflect": {"type": "bool"},
                "no_precision_timers": {"type": "bool"},
                "out_delay": {"type": "int"},
                "outbound_route_filter": {
                    "options": {
                        "bgp_orf_cisco_mode": {"type": "bool"},
                        "prefix_based": {
                            "options": {
                                "accept": {
                                    "options": {
                                        "inet": {"type": "bool"},
                                        "inet6": {"type": "bool"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                    },
                    "type": "dict",
                },
                "output_queue_priority": {
                    "options": {
                        "defaults": {
                            "options": {
                                "high": {
                                    "options": {
                                        "expedited": {"type": "bool"},
                                        "priority": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                                "low": {
                                    "options": {
                                        "expedited": {"type": "bool"},
                                        "priority": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                                "medium": {
                                    "options": {
                                        "expedited": {"type": "bool"},
                                        "priority": {"type": "int"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "expedited_update_tokens": {
                            "type": "int",
                            "no_log": True,
                        },
                        "priority_update_tokens": {
                            "elements": "dict",
                            "no_log": True,
                            "options": {
                                "priority": {"required": True, "type": "int"},
                                "update_tokens": {
                                    "required": True,
                                    "type": "int",
                                    "no_log": True,
                                },
                            },
                            "type": "list",
                        },
                    },
                    "type": "dict",
                },
                "passive": {"type": "bool"},
                "path_selection": {
                    "options": {
                        "always_compare_med": {"type": "bool"},
                        "as_path_ignore": {"type": "bool"},
                        "cisco_non_deterministic": {"type": "bool"},
                        "external_router_id": {"type": "bool"},
                        "l2vpn_use_bgp_rules": {"type": "bool"},
                        "med_plus_igp": {
                            "options": {
                                "igp_multiplier": {"type": "int"},
                                "med_multiplier": {"type": "int"},
                                "set": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                    },
                    "type": "dict",
                },
                "peer_as": {"type": "str"},
                "precision_timers": {"type": "bool"},
                "preference": {"type": "str"},
                "remove_private": {
                    "options": {
                        "all": {"type": "bool"},
                        "all_replace": {"type": "bool"},
                        "all_replace_nearest": {"type": "bool"},
                        "no_peer_loop_check": {"type": "bool"},
                        "set": {"type": "bool"},
                    },
                    "type": "dict",
                },
                "rfc6514_compliant_safi129": {"type": "bool"},
                "route_server_client": {"type": "bool"},
                "send_addpath_optimization": {"type": "bool"},
                "snmp_options": {
                    "options": {
                        "backward_traps_only_from_established": {
                            "type": "bool",
                        },
                        "emit_inet_address_length_in_oid": {"type": "bool"},
                    },
                    "type": "dict",
                },
                "sr_preference_override": {"type": "str"},
                "stale_labels_holddown_period": {"type": "int"},
                "tcp_aggressive_transmission": {"type": "bool"},
                "tcp_mss": {"type": "int"},
                "traceoptions": {
                    "options": {
                        "file": {
                            "options": {
                                "filename": {"required": True, "type": "str"},
                                "files": {"type": "int"},
                                "no_world_readable": {"type": "bool"},
                                "size": {"type": "int"},
                                "world_readable": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "flag": {
                            "elements": "dict",
                            "options": {
                                "detail": {"type": "bool"},
                                "disable": {"type": "bool"},
                                "filter": {
                                    "options": {
                                        "match_on_prefix": {"type": "bool"},
                                        "policy": {"type": "str"},
                                        "set": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "name": {
                                    "choices": [
                                        "4byte-as",
                                        "add-path",
                                        "all",
                                        "bfd",
                                        "damping",
                                        "egress-te",
                                        "general",
                                        "graceful-restart",
                                        "keepalive",
                                        "normal",
                                        "nsr-synchronization",
                                        "open",
                                        "packets",
                                        "policy",
                                        "refresh",
                                        "route",
                                        "state",
                                        "task",
                                        "thread-io",
                                        "thread-update-io",
                                        "timer",
                                        "update",
                                    ],
                                    "required": True,
                                    "type": "str",
                                },
                                "receive": {"type": "bool"},
                                "send": {"type": "bool"},
                            },
                            "type": "list",
                        },
                    },
                    "type": "dict",
                },
                "traffic_statistics_labeled_path": {
                    "options": {
                        "file": {
                            "options": {
                                "filename": {"type": "str"},
                                "files": {"type": "int"},
                                "no_world_readable": {"type": "bool"},
                                "size": {"type": "int"},
                                "world_readable": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "interval": {"type": "int"},
                    },
                    "type": "dict",
                },
                "ttl": {"type": "int"},
                "unconfigured_peer_graceful_restart": {"type": "bool"},
                "vpn_apply_export": {"type": "bool"},
            },
            "type": "dict",
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "purged",
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "parsed",
                "rendered",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
