/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.tomcat.util.buf.ByteBufferHolder;
import org.apache.tomcat.util.net.SocketWrapperBase;

public class WriteBuffer {
    private final int bufferSize;
    private final LinkedBlockingDeque<ByteBufferHolder> buffers = new LinkedBlockingDeque();

    public WriteBuffer(int n) {
        this.bufferSize = n;
    }

    void clear() {
        this.buffers.clear();
    }

    void add(byte[] byArray, int n, int n2) {
        ByteBufferHolder byteBufferHolder = this.getByteBufferHolder(n2);
        byteBufferHolder.getBuf().put(byArray, n, n2);
    }

    public void add(ByteBuffer byteBuffer) {
        ByteBufferHolder byteBufferHolder = this.getByteBufferHolder(byteBuffer.remaining());
        byteBufferHolder.getBuf().put(byteBuffer);
    }

    private ByteBufferHolder getByteBufferHolder(int n) {
        ByteBufferHolder byteBufferHolder = this.buffers.peekLast();
        if (byteBufferHolder == null || byteBufferHolder.isFlipped() || byteBufferHolder.getBuf().remaining() < n) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(Math.max(this.bufferSize, n));
            byteBufferHolder = new ByteBufferHolder(byteBuffer, false);
            this.buffers.add(byteBufferHolder);
        }
        return byteBufferHolder;
    }

    public boolean isEmpty() {
        return this.buffers.isEmpty();
    }

    ByteBuffer[] toArray(ByteBuffer ... byteBufferArray) {
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (!byteBuffer.hasRemaining()) continue;
            arrayList.add(byteBuffer);
        }
        for (ByteBufferHolder byteBufferHolder : this.buffers) {
            byteBufferHolder.flip();
            arrayList.add(byteBufferHolder.getBuf());
        }
        this.buffers.clear();
        return arrayList.toArray(new ByteBuffer[0]);
    }

    boolean write(SocketWrapperBase<?> socketWrapperBase, boolean bl) throws IOException {
        Iterator<ByteBufferHolder> iterator = this.buffers.iterator();
        boolean bl2 = false;
        while (!bl2 && iterator.hasNext()) {
            ByteBufferHolder byteBufferHolder = iterator.next();
            byteBufferHolder.flip();
            if (bl) {
                socketWrapperBase.writeBlocking(byteBufferHolder.getBuf());
            } else {
                socketWrapperBase.writeNonBlockingInternal(byteBufferHolder.getBuf());
            }
            if (byteBufferHolder.getBuf().remaining() == 0) {
                iterator.remove();
                continue;
            }
            bl2 = true;
        }
        return bl2;
    }

    public boolean write(Sink sink, boolean bl) throws IOException {
        Iterator<ByteBufferHolder> iterator = this.buffers.iterator();
        boolean bl2 = false;
        while (!bl2 && iterator.hasNext()) {
            ByteBufferHolder byteBufferHolder = iterator.next();
            byteBufferHolder.flip();
            bl2 = sink.writeFromBuffer(byteBufferHolder.getBuf(), bl);
            if (bl2) continue;
            iterator.remove();
        }
        return bl2;
    }

    public static interface Sink {
        public boolean writeFromBuffer(ByteBuffer var1, boolean var2) throws IOException;
    }
}

