/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.modeler.AttributeInfo;
import org.apache.tomcat.util.modeler.BaseModelMBean;
import org.apache.tomcat.util.modeler.FeatureInfo;
import org.apache.tomcat.util.modeler.NotificationInfo;
import org.apache.tomcat.util.modeler.OperationInfo;
import org.apache.tomcat.util.res.StringManager;

public class ManagedBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final StringManager sm = StringManager.getManager(ManagedBean.class);
    private static final String BASE_MBEAN = "org.apache.tomcat.util.modeler.BaseModelMBean";
    static final Class<?>[] NO_ARGS_PARAM_SIG = new Class[0];
    private final ReadWriteLock mBeanInfoLock = new ReentrantReadWriteLock();
    private volatile transient MBeanInfo info = null;
    private final Map<String, AttributeInfo> attributes = new HashMap<String, AttributeInfo>();
    private final Map<String, OperationInfo> operations = new HashMap<String, OperationInfo>();
    protected String className = "org.apache.tomcat.util.modeler.BaseModelMBean";
    protected String description = null;
    protected String domain = null;
    protected String group = null;
    protected String name = null;
    private NotificationInfo[] notifications = new NotificationInfo[0];
    protected String type = null;

    public ManagedBean() {
        AttributeInfo attributeInfo = new AttributeInfo();
        attributeInfo.setName("modelerType");
        attributeInfo.setDescription("Type of the modeled resource. Can be set only once");
        attributeInfo.setType("java.lang.String");
        attributeInfo.setWriteable(false);
        this.addAttribute(attributeInfo);
    }

    public AttributeInfo[] getAttributes() {
        return this.attributes.values().toArray(new AttributeInfo[0]);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.mBeanInfoLock.writeLock().lock();
        try {
            this.className = string;
            this.info = null;
        }
        finally {
            this.mBeanInfoLock.writeLock().unlock();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.mBeanInfoLock.writeLock().lock();
        try {
            this.description = string;
            this.info = null;
        }
        finally {
            this.mBeanInfoLock.writeLock().unlock();
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.mBeanInfoLock.writeLock().lock();
        try {
            this.name = string;
            this.info = null;
        }
        finally {
            this.mBeanInfoLock.writeLock().unlock();
        }
    }

    public NotificationInfo[] getNotifications() {
        return this.notifications;
    }

    public OperationInfo[] getOperations() {
        return this.operations.values().toArray(new OperationInfo[0]);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.mBeanInfoLock.writeLock().lock();
        try {
            this.type = string;
            this.info = null;
        }
        finally {
            this.mBeanInfoLock.writeLock().unlock();
        }
    }

    public void addAttribute(AttributeInfo attributeInfo) {
        this.attributes.put(attributeInfo.getName(), attributeInfo);
    }

    public void addNotification(NotificationInfo notificationInfo) {
        this.mBeanInfoLock.writeLock().lock();
        try {
            NotificationInfo[] notificationInfoArray = new NotificationInfo[this.notifications.length + 1];
            System.arraycopy(this.notifications, 0, notificationInfoArray, 0, this.notifications.length);
            notificationInfoArray[this.notifications.length] = notificationInfo;
            this.notifications = notificationInfoArray;
            this.info = null;
        }
        finally {
            this.mBeanInfoLock.writeLock().unlock();
        }
    }

    public void addOperation(OperationInfo operationInfo) {
        this.operations.put(this.createOperationKey(operationInfo), operationInfo);
    }

    public DynamicMBean createMBean(Object object) throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        BaseModelMBean baseModelMBean;
        if (this.getClassName().equals(BASE_MBEAN)) {
            baseModelMBean = new BaseModelMBean();
        } else {
            Class<?> clazz = null;
            Exception exception = null;
            try {
                clazz = Class.forName(this.getClassName());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (clazz == null) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader != null) {
                        clazz = classLoader.loadClass(this.getClassName());
                    }
                }
                catch (Exception exception3) {
                    exception = exception3;
                }
            }
            if (clazz == null) {
                throw new MBeanException(exception, sm.getString("managedMBean.cannotLoadClass", new Object[]{this.getClassName()}));
            }
            try {
                baseModelMBean = (BaseModelMBean)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (RuntimeOperationsException runtimeOperationsException) {
                throw runtimeOperationsException;
            }
            catch (Exception exception4) {
                throw new MBeanException(exception4, sm.getString("managedMBean.cannotInstantiateClass", new Object[]{this.getClassName()}));
            }
        }
        baseModelMBean.setManagedBean(this);
        if (object != null) {
            baseModelMBean.setManagedResource(object, "ObjectReference");
        }
        return baseModelMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MBeanInfo getMBeanInfo() {
        this.mBeanInfoLock.readLock().lock();
        try {
            if (this.info != null) {
                MBeanInfo mBeanInfo = this.info;
                return mBeanInfo;
            }
        }
        finally {
            this.mBeanInfoLock.readLock().unlock();
        }
        this.mBeanInfoLock.writeLock().lock();
        try {
            Object object;
            if (this.info == null) {
                object = this.getAttributes();
                MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[((AttributeInfo[])object).length];
                for (int i = 0; i < ((AttributeInfo[])object).length; ++i) {
                    mBeanAttributeInfoArray[i] = object[i].createAttributeInfo();
                }
                OperationInfo[] operationInfoArray = this.getOperations();
                MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[operationInfoArray.length];
                for (int i = 0; i < operationInfoArray.length; ++i) {
                    mBeanOperationInfoArray[i] = operationInfoArray[i].createOperationInfo();
                }
                NotificationInfo[] notificationInfoArray = this.getNotifications();
                MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[notificationInfoArray.length];
                for (int i = 0; i < notificationInfoArray.length; ++i) {
                    mBeanNotificationInfoArray[i] = notificationInfoArray[i].createNotificationInfo();
                }
                this.info = new MBeanInfo(this.getClassName(), this.getDescription(), mBeanAttributeInfoArray, new MBeanConstructorInfo[0], mBeanOperationInfoArray, mBeanNotificationInfoArray);
            }
            object = this.info;
            return object;
        }
        finally {
            this.mBeanInfoLock.writeLock().unlock();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ManagedBean[");
        stringBuilder.append("name=");
        stringBuilder.append(this.name);
        stringBuilder.append(", className=");
        stringBuilder.append(this.className);
        stringBuilder.append(", description=");
        stringBuilder.append(this.description);
        if (this.group != null) {
            stringBuilder.append(", group=");
            stringBuilder.append(this.group);
        }
        stringBuilder.append(", type=");
        stringBuilder.append(this.type);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    Method getGetter(String string, BaseModelMBean baseModelMBean, Object object) throws AttributeNotFoundException, ReflectionException {
        Object object2;
        Method method = null;
        AttributeInfo attributeInfo = this.attributes.get(string);
        if (attributeInfo == null) {
            throw new AttributeNotFoundException(sm.getString("managedMBean.noAttribute", new Object[]{string, object}));
        }
        String string2 = attributeInfo.getGetMethod();
        NoSuchMethodException noSuchMethodException = null;
        try {
            object2 = baseModelMBean;
            method = object2.getClass().getMethod(string2, NO_ARGS_PARAM_SIG);
        }
        catch (NoSuchMethodException noSuchMethodException2) {
            noSuchMethodException = noSuchMethodException2;
        }
        if (method == null && object != null) {
            try {
                object2 = object;
                method = object2.getClass().getMethod(string2, NO_ARGS_PARAM_SIG);
                noSuchMethodException = null;
            }
            catch (NoSuchMethodException noSuchMethodException3) {
                noSuchMethodException = noSuchMethodException3;
            }
        }
        if (noSuchMethodException != null) {
            throw new ReflectionException(noSuchMethodException, sm.getString("managedMBean.noGet", new Object[]{string2, object}));
        }
        return method;
    }

    public Method getSetter(String string, BaseModelMBean baseModelMBean, Object object) throws AttributeNotFoundException, ReflectionException {
        Object object2;
        Method method = null;
        AttributeInfo attributeInfo = this.attributes.get(string);
        if (attributeInfo == null) {
            throw new AttributeNotFoundException(sm.getString("managedMBean.noAttribute", new Object[]{string, object}));
        }
        String string2 = attributeInfo.getSetMethod();
        String string3 = attributeInfo.getType();
        Class[] classArray = new Class[]{BaseModelMBean.getAttributeClass(string3)};
        NoSuchMethodException noSuchMethodException = null;
        try {
            object2 = baseModelMBean;
            method = object2.getClass().getMethod(string2, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException2) {
            noSuchMethodException = noSuchMethodException2;
        }
        if (method == null && object != null) {
            try {
                object2 = object;
                method = object2.getClass().getMethod(string2, classArray);
                noSuchMethodException = null;
            }
            catch (NoSuchMethodException noSuchMethodException3) {
                noSuchMethodException = noSuchMethodException3;
            }
        }
        if (noSuchMethodException != null) {
            throw new ReflectionException(noSuchMethodException, sm.getString("managedMBean.noSet", new Object[]{string2, object}));
        }
        return method;
    }

    public Method getInvoke(String string, Object[] objectArray, String[] stringArray, BaseModelMBean baseModelMBean, Object object) throws MBeanException, ReflectionException {
        Method method = null;
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (objectArray.length != stringArray.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException(sm.getString("managedMBean.inconsistentArguments")), sm.getString("managedMBean.inconsistentArguments"));
        }
        OperationInfo operationInfo = this.operations.get(this.createOperationKey(string, stringArray));
        if (operationInfo == null) {
            throw new MBeanException(new ServiceNotFoundException(sm.getString("managedMBean.noOperation", new Object[]{string})), sm.getString("managedMBean.noOperation", new Object[]{string}));
        }
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = BaseModelMBean.getAttributeClass(stringArray[i]);
        }
        NoSuchMethodException noSuchMethodException = null;
        try {
            BaseModelMBean baseModelMBean2 = baseModelMBean;
            method = baseModelMBean2.getClass().getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException2) {
            noSuchMethodException = noSuchMethodException2;
        }
        try {
            if (method == null && object != null) {
                Object object2 = object;
                method = object2.getClass().getMethod(string, classArray);
            }
        }
        catch (NoSuchMethodException noSuchMethodException3) {
            noSuchMethodException = noSuchMethodException3;
        }
        if (method == null) {
            throw new ReflectionException(noSuchMethodException, sm.getString("managedMBean.noMethod", new Object[]{string}));
        }
        return method;
    }

    private String createOperationKey(OperationInfo operationInfo) {
        StringBuilder stringBuilder = new StringBuilder(operationInfo.getName());
        stringBuilder.append('(');
        StringUtils.join((Object[])operationInfo.getSignature(), (char)',', FeatureInfo::getType, (StringBuilder)stringBuilder);
        stringBuilder.append(')');
        return stringBuilder.toString().intern();
    }

    private String createOperationKey(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('(');
        StringUtils.join((String[])stringArray, (char)',', (StringBuilder)stringBuilder);
        stringBuilder.append(')');
        return stringBuilder.toString().intern();
    }
}

