/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXObjectList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class TeXReader
implements Readable,
Closeable {
    private TeXApp texApp;
    private Reader reader;
    private TeXReader parent;
    private Object source;
    private TeXObjectList pending;
    private int pendingChar = -1;
    private Charset charset;
    private boolean isOpen = false;
    private boolean eofFound = false;

    public TeXReader(TeXReader teXReader, String string) throws IOException {
        this(teXReader == null ? null : teXReader.getTeXApp(), string);
    }

    public TeXReader(TeXApp teXApp, TeXReader teXReader, String string) throws IOException {
        this.parent = teXReader;
        this.source = string;
        this.texApp = teXApp;
        this.reader = new StringReader(string);
        this.isOpen = true;
    }

    public TeXReader(TeXApp teXApp, String string) throws IOException {
        this(teXApp, null, string);
    }

    public TeXReader(TeXReader teXReader, File file, Charset charset) throws IOException {
        this(teXReader == null ? null : teXReader.getTeXApp(), teXReader, file, charset);
    }

    public TeXReader(TeXApp teXApp, TeXReader teXReader, File file, Charset charset) throws IOException {
        if (teXApp == null) {
            throw new NullPointerException("Null TeXApp");
        }
        this.parent = teXReader;
        this.source = file;
        this.texApp = teXApp;
        if (charset == null) {
            charset = teXReader != null ? teXReader.charset : Charset.defaultCharset();
        }
        this.reader = new LineNumberReader(new LineNumberReader(teXApp.createBufferedReader(file.toPath(), charset)));
        this.charset = charset;
        this.isOpen = true;
    }

    public TeXReader(TeXReader teXReader, File file) throws IOException {
        this(teXReader, file, null);
    }

    public TeXReader(TeXApp teXApp, File file) throws IOException {
        this(teXApp, null, file, null);
    }

    public TeXReader(TeXApp teXApp, File file, Charset charset) throws IOException {
        this(teXApp, null, file, charset);
    }

    public int getLineNumber() {
        if (this.reader instanceof LineNumberReader) {
            return ((LineNumberReader)this.reader).getLineNumber();
        }
        return -1;
    }

    public void mark(int n) throws IOException {
        this.reader.mark(n);
    }

    public void reset() throws IOException {
        this.reader.reset();
    }

    public int read() throws IOException {
        int n;
        if (this.pendingChar != -1) {
            n = this.pendingChar;
            this.pendingChar = -1;
        } else {
            if (this.isClosed()) {
                return -1;
            }
            n = this.reader.read();
        }
        if (n == -1) {
            this.eofFound = true;
        }
        if (Character.isSurrogate((char)n)) {
            int n2 = this.reader.read();
            if (n2 != -1 && Character.isSurrogatePair((char)n, (char)n2)) {
                n = Character.toCodePoint((char)n, (char)n2);
            } else {
                this.pendingChar = n2;
            }
        }
        return n;
    }

    public int read(char[] cArray) throws IOException {
        if (this.isClosed()) {
            return -1;
        }
        int n = this.reader.read(cArray);
        if (n == -1) {
            this.eofFound = true;
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.isClosed()) {
            return -1;
        }
        int n3 = this.reader.read(cArray, n, n2);
        if (n3 == -1) {
            this.eofFound = true;
        }
        return n3;
    }

    @Override
    public int read(CharBuffer charBuffer) throws IOException {
        if (this.isClosed()) {
            return -1;
        }
        int n = this.reader.read(charBuffer);
        if (n == -1) {
            this.eofFound = true;
        }
        return n;
    }

    public long skip(long l) throws IOException {
        return this.reader.skip(l);
    }

    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
        this.reader.close();
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public boolean isEnded() {
        return this.eofFound;
    }

    public void closeAll() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            this.texApp.error(iOException);
        }
        this.pending = null;
        if (this.parent != null) {
            this.parent.closeAll();
        }
    }

    public Object getSource() {
        return this.source;
    }

    public TeXReader getParent() {
        return this.parent;
    }

    public TeXReader getBaseReader() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getBaseReader();
    }

    public Reader getReader() {
        return this.reader;
    }

    public boolean isDescendantOf(TeXReader teXReader) {
        if (this.parent == null) {
            return false;
        }
        if (teXReader == this.parent) {
            return true;
        }
        return this.parent.isDescendantOf(teXReader);
    }

    public void setParent(TeXReader teXReader) {
        if (this == teXReader) {
            throw new IllegalArgumentException("Reader can't be its own parent");
        }
        if (teXReader != null && teXReader.isDescendantOf(this)) {
            throw new IllegalArgumentException("Parent reader can't be its child's descendant");
        }
        this.parent = teXReader;
    }

    public String toString() {
        int n = -1;
        if (this.reader instanceof LineNumberReader) {
            n = ((LineNumberReader)this.reader).getLineNumber();
        }
        return String.format("%s[source=%s,line=%d,pending=%s,isOpen=%s,eofFound=%s,parent=%s]", this.getClass().getSimpleName(), this.source, n, this.pending, this.isOpen, this.eofFound, this.parent == null ? null : this.parent.source);
    }

    public void setPending(TeXObjectList teXObjectList) {
        this.pending = teXObjectList;
    }

    public TeXObjectList getPending() {
        return this.pending;
    }

    public boolean hasPending() {
        return this.pending != null;
    }

    public Charset getEncoding() {
        return this.charset;
    }

    public TeXApp getTeXApp() {
        return this.texApp;
    }
}

