/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.DoubleParam;
import com.dickimawbooks.texparserlib.ParameterToken;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.SpecialToken;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class Param
extends AbstractTeXObject
implements ParameterToken {
    private int digit;
    protected int charCode = 35;

    public Param(int n) {
        this.setDigit(n);
    }

    @Override
    public Object clone() {
        Param param = new Param(this.digit);
        param.setCharCode(this.getCharCode());
        return param;
    }

    public int getDigit() {
        return this.digit;
    }

    public void setDigit(int n) {
        this.digit = n;
    }

    @Override
    public boolean isSingleToken() {
        return false;
    }

    public void setCharCode(int n) {
        this.charCode = n;
    }

    @Override
    public int getCharCode() {
        return this.charCode;
    }

    public int getCatCode() {
        return 6;
    }

    @Override
    public TeXObjectList splitTokens(TeXParser teXParser) {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(new SpecialToken(this, this.charCode, 6));
        if (this.digit > 0) {
            teXObjectList.add(teXParser.getListener().getOther(48 + this.digit));
        }
        return teXObjectList;
    }

    @Override
    public TeXObject reconstitute(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        byte by = TeXObjectList.POP_SHORT;
        boolean bl = false;
        TeXObject teXObject = TeXParserUtils.peek(teXParser, teXObjectList, by);
        Param param = teXParser.getListener().getParam(0);
        param.setCharCode(this.getCharCode());
        AbstractTeXObject abstractTeXObject = param;
        if (teXObject instanceof ParameterToken) {
            DoubleParam doubleParam = teXParser.getListener().getDoubleParam((ParameterToken)teXObject);
            doubleParam.setCharCode(this.getCharCode());
            abstractTeXObject = doubleParam;
            bl = true;
        } else if (teXObject.isSingleToken()) {
            int n = ((SingleToken)teXObject).getCharCode();
            int n2 = ((SingleToken)teXObject).getCatCode();
            if (n >= 49 && n <= 57) {
                param.setDigit(n - 48);
                bl = true;
            } else if (n2 == 1) {
                param.setDigit(-1);
            } else if (n2 == 6 && teXObject instanceof SpecialToken) {
                SpecialToken specialToken = (SpecialToken)teXObject;
                TeXParserUtils.pop(teXParser, teXObjectList, by);
                ParameterToken parameterToken = (ParameterToken)specialToken.getObject().reconstitute(teXParser, teXObjectList);
                DoubleParam doubleParam = teXParser.getListener().getDoubleParam(parameterToken);
                doubleParam.setCharCode(this.getCharCode());
                abstractTeXObject = doubleParam;
            }
        }
        if (bl) {
            TeXParserUtils.pop(teXParser, teXObjectList, by);
        }
        return abstractTeXObject;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.digit <= 0) {
            TeXObject teXObject = teXObjectList.peek();
            throw new TeXSyntaxException(teXParser, "tex.error.bad_param", teXObject == null ? "" : teXObject.toString(teXParser));
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        if (this.digit <= 0) {
            TeXObject teXObject = teXParser.peekStack();
            throw new TeXSyntaxException(teXParser, "tex.error.bad_param", teXObject == null ? "" : teXObject.toString(teXParser));
        }
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.format();
    }

    @Override
    public String format() {
        if (this.digit <= 0) {
            return new String(Character.toChars(this.charCode));
        }
        return String.format("%s%d", new String(Character.toChars(this.charCode)), this.digit);
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.format());
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.charCode));
        if (this.digit != -1) {
            teXObjectList.add(teXParser.getListener().getOther(48 + this.digit));
        }
        return teXObjectList;
    }

    @Override
    public ParameterToken next() {
        return null;
    }

    @Override
    public Param tail() {
        return this;
    }
}

