
# 11 "plugins/ltac/g_class.mlg"
 

open Class_tactics
open Stdarg
open Classes


# 11 "plugins/ltac/g_class.ml"

let _ = Mltop.add_known_module "rocq-runtime.plugins.ltac"
let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"Typeclasses_Unfold_Settings" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Typeclasses",
           Vernacextend.TyTerminal
           ("Transparent",
            Vernacextend.TyNonTerminal (Extend.TUlist1 (Extend.TUentry (Genarg.get_arg_tag wit_reference)),
            Vernacextend.TyNil))),
          (let coqpp_body cl locality = Vernactypes.vtdefault (fun () -> 
# 25 "plugins/ltac/g_class.mlg"
                                                            
    set_typeclass_transparency_com ~locality cl true
  
# 28 "plugins/ltac/g_class.ml"
) in
            fun cl ?loc ~atts () -> coqpp_body cl (Attributes.parse 
# 24 "plugins/ltac/g_class.mlg"
                 Attributes.hint_locality
# 33 "plugins/ltac/g_class.ml"
 atts)),
          None))]

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"Typeclasses_Rigid_Settings" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Typeclasses",
           Vernacextend.TyTerminal
           ("Opaque",
            Vernacextend.TyNonTerminal (Extend.TUlist1 (Extend.TUentry (Genarg.get_arg_tag wit_reference)),
            Vernacextend.TyNil))),
          (let coqpp_body cl locality = Vernactypes.vtdefault (fun () -> 
# 32 "plugins/ltac/g_class.mlg"
                                                       
    set_typeclass_transparency_com ~locality cl false
  
# 51 "plugins/ltac/g_class.ml"
) in
            fun cl ?loc ~atts () -> coqpp_body cl (Attributes.parse 
# 31 "plugins/ltac/g_class.mlg"
                 Attributes.hint_locality
# 56 "plugins/ltac/g_class.ml"
 atts)),
          None))]


# 37 "plugins/ltac/g_class.mlg"
 

let pr_debug _prc _prlc _prt b =
  if b then Pp.str "debug" else Pp.mt()


# 68 "plugins/ltac/g_class.ml"

let (wit_debug, debug) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"debug" 
                         {
                         Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                  ([(Procq.Production.make
                                                     (Procq.Rule.stop)
                                                     (fun loc -> 
# 46 "plugins/ltac/g_class.mlg"
           false 
# 78 "plugins/ltac/g_class.ml"
));
                                                   (Procq.Production.make
                                                    (Procq.Rule.next
                                                     (Procq.Rule.stop)
                                                     ((Procq.Symbol.token (Procq.terminal "debug"))))
                                                    (fun _ loc -> 
# 45 "plugins/ltac/g_class.mlg"
                   true 
# 87 "plugins/ltac/g_class.ml"
))]);
                         Tacentries.arg_tag = Some
                                              (Geninterp.val_tag (Genarg.topwit wit_bool));
                         Tacentries.arg_intern = Tacentries.ArgInternWit (wit_bool);
                         Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_bool);
                         Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_bool);
                         Tacentries.arg_printer = ((fun env sigma -> 
                                                  
# 44 "plugins/ltac/g_class.mlg"
                                                 pr_debug 
# 98 "plugins/ltac/g_class.ml"
), (fun env sigma -> 
                                                  
# 44 "plugins/ltac/g_class.mlg"
                                                 pr_debug 
# 103 "plugins/ltac/g_class.ml"
), (fun env sigma -> 
                                                  
# 44 "plugins/ltac/g_class.mlg"
                                                 pr_debug 
# 108 "plugins/ltac/g_class.ml"
));
                         }
let _ = (wit_debug, debug)


# 49 "plugins/ltac/g_class.mlg"
 

let pr_search_strategy_name _prc _prlc _prt = function
  | Dfs -> Pp.str "dfs"
  | Bfs -> Pp.str "bfs"

let pr_search_strategy _prc _prlc _prt = function
  | Some s -> pr_search_strategy_name _prc _prlc _prt s
  | None -> Pp.mt ()


# 126 "plugins/ltac/g_class.ml"

let (wit_eauto_search_strategy_name, eauto_search_strategy_name) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"eauto_search_strategy_name" 
                                                                   {
                                                                   Tacentries.arg_parsing = 
                                                                   Vernacextend.Arg_rules
                                                                   ([(
                                                                    Procq.Production.make
                                                                    (
                                                                    Procq.Rule.next
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Procq.terminal "dfs"))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 63 "plugins/ltac/g_class.mlg"
                 Dfs 
# 143 "plugins/ltac/g_class.ml"
));
                                                                    (
                                                                    Procq.Production.make
                                                                    (
                                                                    Procq.Rule.next
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Procq.terminal "bfs"))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 62 "plugins/ltac/g_class.mlg"
                 Bfs 
# 156 "plugins/ltac/g_class.ml"
))]);
                                                                   Tacentries.arg_tag = 
                                                                   None;
                                                                   Tacentries.arg_intern = 
                                                                   Tacentries.ArgInternFun (fun ist v -> (ist, v));
                                                                   Tacentries.arg_subst = 
                                                                   Tacentries.ArgSubstFun (fun s v -> v);
                                                                   Tacentries.arg_interp = 
                                                                   Tacentries.ArgInterpRet;
                                                                   Tacentries.arg_printer = 
                                                                   ((fun env sigma -> 
                                                                   
# 61 "plugins/ltac/g_class.mlg"
                                                        pr_search_strategy_name 
# 171 "plugins/ltac/g_class.ml"
), (fun env sigma -> 
                                                                   
# 61 "plugins/ltac/g_class.mlg"
                                                        pr_search_strategy_name 
# 176 "plugins/ltac/g_class.ml"
), (fun env sigma -> 
                                                                   
# 61 "plugins/ltac/g_class.mlg"
                                                        pr_search_strategy_name 
# 181 "plugins/ltac/g_class.ml"
));
                                                                   }
let _ = (wit_eauto_search_strategy_name, eauto_search_strategy_name)

let (wit_eauto_search_strategy, eauto_search_strategy) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"eauto_search_strategy" 
                                                         {
                                                         Tacentries.arg_parsing = 
                                                         Vernacextend.Arg_rules
                                                         ([(Procq.Production.make
                                                            (Procq.Rule.stop)
                                                            (fun loc -> 
# 68 "plugins/ltac/g_class.mlg"
           None 
# 195 "plugins/ltac/g_class.ml"
));
                                                          (Procq.Production.make
                                                           (Procq.Rule.next
                                                            (Procq.Rule.next
                                                             (Procq.Rule.next
                                                              (Procq.Rule.stop)
                                                              ((Procq.Symbol.token (Procq.terminal "("))))
                                                             ((Procq.Symbol.nterm eauto_search_strategy_name)))
                                                            ((Procq.Symbol.token (Procq.terminal ")"))))
                                                           (fun _ s _ loc ->
                                                           
# 67 "plugins/ltac/g_class.mlg"
                                                 Some s 
# 209 "plugins/ltac/g_class.ml"
))]);
                                                         Tacentries.arg_tag = 
                                                         None;
                                                         Tacentries.arg_intern = 
                                                         Tacentries.ArgInternFun (fun ist v -> (ist, v));
                                                         Tacentries.arg_subst = 
                                                         Tacentries.ArgSubstFun (fun s v -> v);
                                                         Tacentries.arg_interp = 
                                                         Tacentries.ArgInterpRet;
                                                         Tacentries.arg_printer = 
                                                         ((fun env sigma -> 
                                                         
# 66 "plugins/ltac/g_class.mlg"
                                                   pr_search_strategy 
# 224 "plugins/ltac/g_class.ml"
), (fun env sigma -> 
                                                         
# 66 "plugins/ltac/g_class.mlg"
                                                   pr_search_strategy 
# 229 "plugins/ltac/g_class.ml"
), (fun env sigma -> 
                                                         
# 66 "plugins/ltac/g_class.mlg"
                                                   pr_search_strategy 
# 234 "plugins/ltac/g_class.ml"
));
                                                         }
let _ = (wit_eauto_search_strategy, eauto_search_strategy)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"Typeclasses_Settings" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Typeclasses",
           Vernacextend.TyTerminal
           ("eauto",
            Vernacextend.TyTerminal
            (":=",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_debug),
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_eauto_search_strategy),
             Vernacextend.TyNonTerminal (Extend.TUopt (Extend.TUentry (Genarg.get_arg_tag wit_natural)),
             Vernacextend.TyNil)))))),
          (let coqpp_body d s depth () =
            Vernactypes.vtdefault (fun () -> 
# 74 "plugins/ltac/g_class.mlg"
                                                                                           
     set_typeclasses_debug d;
     Option.iter set_typeclasses_strategy s;
     set_typeclasses_depth depth
   
# 260 "plugins/ltac/g_class.ml"
) in
            fun d s depth ?loc ~atts () ->
            coqpp_body d s depth (Attributes.unsupported_attributes atts)),
          None))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "typeclasses_eauto" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("typeclasses", Tacentries.TyIdent ("eauto", 
                                                               Tacentries.TyIdent ("dfs", 
                                                               Tacentries.TyArg (
                                                               Extend.TUopt (
                                                               Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                               Tacentries.TyIdent ("with", 
                                                               Tacentries.TyArg (
                                                               Extend.TUlist1 (
                                                               Extend.TUentry (Genarg.get_arg_tag wit_preident)), 
                                                               Tacentries.TyNil)))))), 
           (fun d l ist -> 
# 83 "plugins/ltac/g_class.mlg"
      typeclasses_eauto ~depth:d ~strategy:Dfs l 
# 280 "plugins/ltac/g_class.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("typeclasses", Tacentries.TyIdent ("eauto", 
                                                              Tacentries.TyIdent ("bfs", 
                                                              Tacentries.TyArg (
                                                              Extend.TUopt (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                              Tacentries.TyIdent ("with", 
                                                              Tacentries.TyArg (
                                                              Extend.TUlist1 (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_preident)), 
                                                              Tacentries.TyNil)))))), 
          (fun d l ist -> 
# 85 "plugins/ltac/g_class.mlg"
      typeclasses_eauto ~depth:d ~strategy:Bfs l 
# 295 "plugins/ltac/g_class.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("typeclasses", Tacentries.TyIdent ("eauto", 
                                                              Tacentries.TyIdent ("best_effort", 
                                                              Tacentries.TyArg (
                                                              Extend.TUopt (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                              Tacentries.TyIdent ("with", 
                                                              Tacentries.TyArg (
                                                              Extend.TUlist1 (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_preident)), 
                                                              Tacentries.TyNil)))))), 
          (fun d l ist -> 
# 87 "plugins/ltac/g_class.mlg"
      typeclasses_eauto ~depth:d ~best_effort:true l 
# 310 "plugins/ltac/g_class.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("typeclasses", Tacentries.TyIdent ("eauto", 
                                                              Tacentries.TyArg (
                                                              Extend.TUopt (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                              Tacentries.TyIdent ("with", 
                                                              Tacentries.TyArg (
                                                              Extend.TUlist1 (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_preident)), 
                                                              Tacentries.TyNil))))), 
          (fun d l ist -> 
# 89 "plugins/ltac/g_class.mlg"
      typeclasses_eauto ~depth:d l 
# 324 "plugins/ltac/g_class.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("typeclasses", Tacentries.TyIdent ("eauto", 
                                                              Tacentries.TyIdent ("bfs", 
                                                              Tacentries.TyArg (
                                                              Extend.TUopt (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                              Tacentries.TyNil)))), 
          (fun d ist -> 
# 90 "plugins/ltac/g_class.mlg"
                                                         
     typeclasses_eauto ~depth:d ~strategy:Bfs ~only_classes:true [Class_tactics.typeclasses_db] 
# 336 "plugins/ltac/g_class.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("typeclasses", Tacentries.TyIdent ("eauto", 
                                                              Tacentries.TyIdent ("dfs", 
                                                              Tacentries.TyArg (
                                                              Extend.TUopt (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                              Tacentries.TyNil)))), 
          (fun d ist -> 
# 92 "plugins/ltac/g_class.mlg"
                                                         
     typeclasses_eauto ~depth:d ~strategy:Dfs ~only_classes:true [Class_tactics.typeclasses_db] 
# 348 "plugins/ltac/g_class.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("typeclasses", Tacentries.TyIdent ("eauto", 
                                                              Tacentries.TyIdent ("best_effort", 
                                                              Tacentries.TyArg (
                                                              Extend.TUopt (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                              Tacentries.TyNil)))), 
          (fun d ist -> 
# 94 "plugins/ltac/g_class.mlg"
                                                                 
      typeclasses_eauto ~depth:d ~only_classes:true ~best_effort:true [Class_tactics.typeclasses_db] 
# 360 "plugins/ltac/g_class.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("typeclasses", Tacentries.TyIdent ("eauto", 
                                                              Tacentries.TyArg (
                                                              Extend.TUopt (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                              Tacentries.TyNil))), 
          (fun d ist -> 
# 96 "plugins/ltac/g_class.mlg"
                                                   
     typeclasses_eauto ~depth:d ~only_classes:true [Class_tactics.typeclasses_db] 
# 371 "plugins/ltac/g_class.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "head_of_constr" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("head_of_constr", Tacentries.TyArg (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_ident), 
                                                                  Tacentries.TyArg (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                  Tacentries.TyNil))), 
           (fun h c ist -> 
# 101 "plugins/ltac/g_class.mlg"
                                               head_of_constr h c 
# 383 "plugins/ltac/g_class.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "not_evar" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("not_evar", Tacentries.TyArg (
                                                            Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                            Tacentries.TyNil)), 
           (fun ty ist -> 
# 105 "plugins/ltac/g_class.mlg"
                                 not_evar ty 
# 393 "plugins/ltac/g_class.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "is_ground" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("is_ground", Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                             Tacentries.TyNil)), 
           (fun ty ist -> 
# 109 "plugins/ltac/g_class.mlg"
                                  is_ground ty 
# 403 "plugins/ltac/g_class.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "autoapply" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("autoapply", Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                             Tacentries.TyIdent ("with", 
                                                             Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_preident), 
                                                             Tacentries.TyNil)))), 
           (fun c i ist -> 
# 113 "plugins/ltac/g_class.mlg"
                                                    autoapply c i 
# 416 "plugins/ltac/g_class.ml"
)))]

