/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart.command;

import net.sourceforge.plantuml.chart.ChartDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandChartGrid
extends SingleLineCommand2<ChartDiagram> {
    public CommandChartGrid() {
        super(false, CommandChartGrid.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandChartGrid.class.getName(), RegexLeaf.start(), new RegexLeaf("grid"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "AXIS", "(h-axis|v-axis)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ChartDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        String axis = arg.get("AXIS", 0);
        ChartDiagram.GridMode gridMode = ChartDiagram.GridMode.MAJOR;
        if (axis.equals("h-axis")) {
            return diagram.setXGridMode(gridMode);
        }
        if (axis.equals("v-axis")) {
            return diagram.setYGridMode(gridMode);
        }
        return CommandExecutionResult.error("Invalid axis: " + axis);
    }
}

