/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.window;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionImplementation;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionSignature;
import org.opensearch.sql.expression.window.patterns.BufferPatternWindowFunction;
import org.opensearch.sql.expression.window.ranking.DenseRankFunction;
import org.opensearch.sql.expression.window.ranking.RankFunction;
import org.opensearch.sql.expression.window.ranking.RankingWindowFunction;
import org.opensearch.sql.expression.window.ranking.RowNumberFunction;

public final class WindowFunctions {
    public static void register(BuiltinFunctionRepository repository) {
        repository.register(WindowFunctions.rowNumber());
        repository.register(WindowFunctions.rank());
        repository.register(WindowFunctions.denseRank());
        repository.register(WindowFunctions.brain());
    }

    private static DefaultFunctionResolver rowNumber() {
        return WindowFunctions.rankingFunction(BuiltinFunctionName.ROW_NUMBER.getName(), RowNumberFunction::new);
    }

    private static DefaultFunctionResolver rank() {
        return WindowFunctions.rankingFunction(BuiltinFunctionName.RANK.getName(), RankFunction::new);
    }

    private static DefaultFunctionResolver denseRank() {
        return WindowFunctions.rankingFunction(BuiltinFunctionName.DENSE_RANK.getName(), DenseRankFunction::new);
    }

    private static DefaultFunctionResolver brain() {
        FunctionName functionName = BuiltinFunctionName.BRAIN.getName();
        FunctionBuilder functionBuilder = (functionProperties, arguments) -> new BufferPatternWindowFunction(arguments);
        return new DefaultFunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)ImmutableMap.of((Object)new FunctionSignature(functionName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING)), (Object)functionBuilder, (Object)new FunctionSignature(functionName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING)), (Object)functionBuilder, (Object)new FunctionSignature(functionName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.INTEGER)), (Object)functionBuilder, (Object)new FunctionSignature(functionName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.DOUBLE)), (Object)functionBuilder, (Object)new FunctionSignature(functionName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.INTEGER)), (Object)functionBuilder, (Object)new FunctionSignature(functionName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.DOUBLE)), (Object)functionBuilder, (Object)new FunctionSignature(functionName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.INTEGER, (Object)ExprCoreType.DOUBLE)), (Object)functionBuilder, (Object)new FunctionSignature(functionName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.DOUBLE, (Object)ExprCoreType.INTEGER)), (Object)functionBuilder, (Object)new FunctionSignature(functionName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.INTEGER, (Object)ExprCoreType.DOUBLE)), (Object)functionBuilder, (Object)new FunctionSignature(functionName, (List<ExprType>)ImmutableList.of((Object)ExprCoreType.STRING, (Object)ExprCoreType.STRING, (Object)ExprCoreType.DOUBLE, (Object)ExprCoreType.INTEGER)), (Object)functionBuilder));
    }

    private static DefaultFunctionResolver rankingFunction(FunctionName functionName, Supplier<RankingWindowFunction> constructor) {
        FunctionSignature functionSignature = new FunctionSignature(functionName, Collections.emptyList());
        FunctionBuilder functionBuilder = (functionProperties, arguments) -> (FunctionImplementation)constructor.get();
        return new DefaultFunctionResolver(functionName, (Map<FunctionSignature, FunctionBuilder>)ImmutableMap.of((Object)functionSignature, (Object)functionBuilder));
    }

    @Generated
    private WindowFunctions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

