/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.ImmutableAggregateFilterToCaseRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.immutables.value.Value;

@Value.Enclosing
public class AggregateFilterToCaseRule
extends RelRule<Config>
implements TransformationRule {
    protected AggregateFilterToCaseRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            if (!aggregateCall.hasFilter()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelBuilder relBuilder = call.builder();
        Aggregate aggregate = (Aggregate)call.rel(0);
        Project project = (Project)call.rel(1);
        ArrayList<AggregateCall> newCalls = new ArrayList<AggregateCall>(aggregate.getAggCallList().size());
        ArrayList<RexNode> newProjects = new ArrayList<RexNode>(project.getProjects());
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            AggregateCall newCall = AggregateFilterToCaseRule.transform(aggregateCall, relBuilder.getRexBuilder(), relBuilder.getTypeFactory(), newProjects);
            newCalls.add(newCall);
        }
        if (newCalls.equals(aggregate.getAggCallList())) {
            return;
        }
        relBuilder.push(project.getInput()).project(newProjects);
        RelBuilder.GroupKey groupKey = relBuilder.groupKey(aggregate.getGroupSet(), (Iterable<? extends ImmutableBitSet>)aggregate.getGroupSets());
        relBuilder.aggregate(groupKey, (List<AggregateCall>)newCalls);
        call.transformTo(relBuilder.build());
    }

    private static AggregateCall transform(AggregateCall call, RexBuilder rexBuilder, RelDataTypeFactory typeFactory, List<RexNode> newProjects) {
        RexNode arg1;
        if (!call.hasFilter()) {
            return call;
        }
        SqlKind kind = call.getAggregation().getKind();
        RexNode condition = newProjects.get(call.filterArg);
        if (kind == SqlKind.COUNT) {
            arg1 = call.getArgList().size() == 0 ? rexBuilder.makeZeroLiteral(typeFactory.createSqlType(SqlTypeName.INTEGER)) : newProjects.get(call.getArgList().get(0));
        } else {
            if (call.isDistinct() || call.getArgList().size() != 1) {
                return call;
            }
            arg1 = newProjects.get(call.getArgList().get(0));
        }
        RexLiteral arg2 = rexBuilder.makeNullLiteral(((RexNode)arg1).getType());
        RexNode caseWhen = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, condition, arg1, arg2);
        newProjects.add(caseWhen);
        return AggregateCall.create(call.getParserPosition(), call.getAggregation(), call.isDistinct(), call.isApproximate(), call.ignoreNulls(), call.rexList, (List<Integer>)ImmutableList.of((Object)(newProjects.size() - 1)), -1, call.distinctKeys, RelCollations.EMPTY, call.getType(), call.getName());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableAggregateFilterToCaseRule.Config.of().withOperandSupplier(b0 -> b0.operand(Aggregate.class).oneInput(b1 -> b1.operand(Project.class).anyInputs()));

        @Override
        default public AggregateFilterToCaseRule toRule() {
            return new AggregateFilterToCaseRule(this);
        }
    }
}

