/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.generator.sp80038a;

import javax.crypto.SecretKey;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.cryptacular.CryptUtil;
import org.cryptacular.generator.LimitException;
import org.cryptacular.generator.Nonce;
import org.cryptacular.spec.Spec;
import org.cryptacular.util.NonceUtil;

public class EncryptedNonce
implements Nonce {
    private final BlockCipher cipher;
    private final SecretKey key;

    public EncryptedNonce(Spec<BlockCipher> cipherSpec, SecretKey key) {
        this(CryptUtil.assertNotNullArg(cipherSpec, "Cipher spec cannot be null").newInstance(), key);
    }

    public EncryptedNonce(BlockCipher cipher, SecretKey key) {
        this.cipher = CryptUtil.assertNotNullArg(cipher, "Cipher cannot be null");
        this.key = CryptUtil.assertNotNullArgOr(key, v -> v.getEncoded().length == 0, "Secret key cannot be empty");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generate() throws LimitException {
        byte[] result = new byte[this.cipher.getBlockSize()];
        byte[] nonce = NonceUtil.randomNonce(result.length);
        BlockCipher blockCipher = this.cipher;
        synchronized (blockCipher) {
            try {
                this.cipher.init(true, (CipherParameters)new KeyParameter(this.key.getEncoded()));
                this.cipher.processBlock(nonce, 0, result, 0);
                this.cipher.reset();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new LimitException(e);
            }
        }
        return result;
    }

    @Override
    public int getLength() {
        return this.cipher.getBlockSize();
    }
}

