/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationRequestsPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

public class ReservationDefinitionPBImpl
extends ReservationDefinition {
    YarnProtos.ReservationDefinitionProto proto = YarnProtos.ReservationDefinitionProto.getDefaultInstance();
    YarnProtos.ReservationDefinitionProto.Builder builder = null;
    boolean viaProto = false;
    private ReservationRequests reservationReqs;
    private Priority priority = null;

    public ReservationDefinitionPBImpl() {
        this.builder = YarnProtos.ReservationDefinitionProto.newBuilder();
    }

    public ReservationDefinitionPBImpl(YarnProtos.ReservationDefinitionProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ReservationDefinitionProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.reservationReqs != null) {
            this.builder.setReservationRequests(this.convertToProtoFormat(this.reservationReqs));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ReservationDefinitionProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public long getArrival() {
        YarnProtos.ReservationDefinitionProtoOrBuilder p;
        YarnProtos.ReservationDefinitionProtoOrBuilder reservationDefinitionProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasArrival()) {
            return 0L;
        }
        return p.getArrival();
    }

    @Override
    public void setArrival(long earliestStartTime) {
        this.maybeInitBuilder();
        if (earliestStartTime <= 0L) {
            this.builder.clearArrival();
            return;
        }
        this.builder.setArrival(earliestStartTime);
    }

    @Override
    public long getDeadline() {
        YarnProtos.ReservationDefinitionProtoOrBuilder p;
        YarnProtos.ReservationDefinitionProtoOrBuilder reservationDefinitionProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasDeadline()) {
            return 0L;
        }
        return p.getDeadline();
    }

    @Override
    public void setDeadline(long latestEndTime) {
        this.maybeInitBuilder();
        if (latestEndTime <= 0L) {
            this.builder.clearDeadline();
            return;
        }
        this.builder.setDeadline(latestEndTime);
    }

    @Override
    public ReservationRequests getReservationRequests() {
        YarnProtos.ReservationDefinitionProtoOrBuilder p;
        YarnProtos.ReservationDefinitionProtoOrBuilder reservationDefinitionProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.reservationReqs != null) {
            return this.reservationReqs;
        }
        if (!p.hasReservationRequests()) {
            return null;
        }
        this.reservationReqs = this.convertFromProtoFormat(p.getReservationRequests());
        return this.reservationReqs;
    }

    @Override
    public void setReservationRequests(ReservationRequests reservationRequests) {
        if (reservationRequests == null) {
            this.builder.clearReservationRequests();
            return;
        }
        this.reservationReqs = reservationRequests;
    }

    @Override
    public String getReservationName() {
        YarnProtos.ReservationDefinitionProtoOrBuilder p;
        YarnProtos.ReservationDefinitionProtoOrBuilder reservationDefinitionProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasReservationName()) {
            return null;
        }
        return p.getReservationName();
    }

    @Override
    public void setReservationName(String name) {
        this.maybeInitBuilder();
        if (name == null) {
            this.builder.clearReservationName();
            return;
        }
        this.builder.setReservationName(name);
    }

    @Override
    public Priority getPriority() {
        YarnProtos.ReservationDefinitionProtoOrBuilder p;
        YarnProtos.ReservationDefinitionProtoOrBuilder reservationDefinitionProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.priority != null) {
            return this.priority;
        }
        if (!p.hasPriority()) {
            return Priority.UNDEFINED;
        }
        this.priority = this.convertFromProtoFormat(p.getPriority());
        return this.priority;
    }

    @Override
    public void setPriority(Priority priority) {
        this.maybeInitBuilder();
        if (priority == null) {
            this.priority = Priority.UNDEFINED;
        }
        this.priority = priority;
    }

    private PriorityPBImpl convertFromProtoFormat(YarnProtos.PriorityProto p) {
        return new PriorityPBImpl(p);
    }

    private ReservationRequestsPBImpl convertFromProtoFormat(YarnProtos.ReservationRequestsProto p) {
        return new ReservationRequestsPBImpl(p);
    }

    private YarnProtos.ReservationRequestsProto convertToProtoFormat(ReservationRequests t) {
        return ((ReservationRequestsPBImpl)t).getProto();
    }

    public String toString() {
        return "{Arrival: " + this.getArrival() + ", Deadline: " + this.getDeadline() + ", Reservation Name: " + this.getReservationName() + ", Recurrence expression: " + this.getRecurrenceExpression() + ", Priority: " + this.getPriority().toString() + ", Resources: " + this.getReservationRequests() + "}";
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ReservationDefinitionPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    @Override
    public String getRecurrenceExpression() {
        YarnProtos.ReservationDefinitionProtoOrBuilder p;
        YarnProtos.ReservationDefinitionProtoOrBuilder reservationDefinitionProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (p.hasRecurrenceExpression()) {
            String recurrenceExpression = p.getRecurrenceExpression();
            return recurrenceExpression;
        }
        return "0";
    }

    @Override
    public void setRecurrenceExpression(String recurrenceExpression) {
        this.maybeInitBuilder();
        if (recurrenceExpression == null) {
            this.builder.clearRecurrenceExpression();
            return;
        }
        this.builder.setRecurrenceExpression(recurrenceExpression);
    }
}

