/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.security.PatchOperation;
import org.opensearch.client.opensearch.security.PatchRoleResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PatchRoleRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PatchRoleRequest> {
    @Nonnull
    private final List<PatchOperation> operations;
    @Nonnull
    private final String role;
    public static final JsonpDeserializer<PatchRoleRequest> _DESERIALIZER = PatchRoleRequest.createPatchRoleRequestDeserializer();
    public static final Endpoint<PatchRoleRequest, PatchRoleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PatchRoleRequest, PatchRoleResponse>(request -> "PATCH", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_security/api/roles/");
        SimpleEndpoint.pathEncode(request.role, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PatchRoleResponse._DESERIALIZER);

    private PatchRoleRequest(Builder builder) {
        super(builder);
        this.operations = ApiTypeHelper.unmodifiableRequired(builder.operations, (Object)this, "operations");
        this.role = ApiTypeHelper.requireNonNull(builder.role, this, "role");
    }

    public static PatchRoleRequest of(Function<Builder, ObjectBuilder<PatchRoleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<PatchOperation> operations() {
        return this.operations;
    }

    @Nonnull
    public final String role() {
        return this.role;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (PatchOperation item0 : this.operations) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static JsonpDeserializer<PatchRoleRequest> createPatchRoleRequestDeserializer() {
        JsonpDeserializer<List<PatchOperation>> valueDeserializer = JsonpDeserializer.arrayDeserializer(PatchOperation._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper) -> new Builder().operations((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper)).build());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.operations.hashCode();
        result = 31 * result + this.role.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchRoleRequest other = (PatchRoleRequest)o;
        return this.operations.equals(other.operations) && this.role.equals(other.role);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PatchRoleRequest> {
        private List<PatchOperation> operations;
        private String role;

        public Builder() {
        }

        private Builder(PatchRoleRequest o) {
            super(o);
            this.operations = Builder._listCopy(o.operations);
            this.role = o.role;
        }

        private Builder(Builder o) {
            super(o);
            this.operations = Builder._listCopy(o.operations);
            this.role = o.role;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder operations(List<PatchOperation> list) {
            this.operations = Builder._listAddAll(this.operations, list);
            return this;
        }

        @Nonnull
        public final Builder operations(PatchOperation value, PatchOperation ... values) {
            this.operations = Builder._listAdd(this.operations, value, values);
            return this;
        }

        @Nonnull
        public final Builder operations(Function<PatchOperation.Builder, ObjectBuilder<PatchOperation>> fn) {
            return this.operations(fn.apply(new PatchOperation.Builder()).build(), new PatchOperation[0]);
        }

        @Nonnull
        public final Builder role(String value) {
            this.role = value;
            return this;
        }

        @Override
        @Nonnull
        public PatchRoleRequest build() {
            this._checkSingleUse();
            return new PatchRoleRequest(this);
        }
    }
}

