/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServer;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class AuthenticationCompleteCallbackSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    public AuthenticationCompleteCallbackSaslServerFactory(SaslServerFactory delegate) {
        super(delegate);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, final CallbackHandler cbh) throws SaslException {
        SaslServer delegateSaslServer = this.delegate.createSaslServer(mechanism, protocol, serverName, props, cbh);
        return delegateSaslServer == null ? null : new AbstractDelegatingSaslServer(delegateSaslServer){
            private final AtomicBoolean complete;
            {
                super(delegate);
                this.complete = new AtomicBoolean();
            }

            @Override
            public byte[] evaluateResponse(byte[] response) throws SaslException {
                try {
                    byte[] challenge = this.delegate.evaluateResponse(response);
                    if (this.isComplete() && this.complete.compareAndSet(false, true)) {
                        try {
                            cbh.handle(new Callback[]{AuthenticationCompleteCallback.SUCCEEDED});
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return challenge;
                }
                catch (Error | RuntimeException | SaslException e) {
                    if (this.isComplete() && this.complete.compareAndSet(false, true)) {
                        try {
                            cbh.handle(new Callback[]{AuthenticationCompleteCallback.FAILED});
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
            }

            @Override
            public void dispose() throws SaslException {
                SaslException deferred = null;
                try {
                    super.dispose();
                }
                catch (SaslException e) {
                    deferred = e;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.complete.compareAndSet(false, true)) {
                    try {
                        cbh.handle(new Callback[]{AuthenticationCompleteCallback.FAILED});
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (deferred != null) {
                    throw deferred;
                }
            }
        };
    }
}

