/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.broker;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.authenticators.broker.AbstractIdpAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class IdpConfirmOverrideLinkAuthenticator
extends AbstractIdpAuthenticator {
    public static final String OVERRIDE_LINK = "OVERRIDE_LINK";

    @Override
    protected void authenticateImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        RealmModel realm = context.getRealm();
        KeycloakSession session = context.getSession();
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        UserModel user = IdpConfirmOverrideLinkAuthenticator.getExistingUser(session, realm, authSession);
        String providerAlias = brokerContext.getIdpConfig().getAlias();
        FederatedIdentityModel federatedIdentity = session.users().getFederatedIdentity(realm, user, providerAlias);
        if (federatedIdentity == null) {
            context.success();
            return;
        }
        String newBrokerUsername = brokerContext.getUsername();
        String oldBrokerUsername = federatedIdentity.getUserName();
        Response challenge = context.form().setStatus(Response.Status.OK).setAttribute("identityProviderBrokerCtx", (Object)brokerContext).setError("federatedIdentityConfirmOverrideMessage", new Object[]{user.getUsername(), providerAlias, newBrokerUsername, providerAlias, oldBrokerUsername}).createIdpLinkConfirmOverrideLinkPage();
        context.challenge(challenge);
    }

    @Override
    protected void actionImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String action = (String)formData.getFirst((Object)"submitAction");
        if (!"confirmOverride".equals(action)) {
            throw new AuthenticationFlowException("Unknown action: " + action, AuthenticationFlowError.INTERNAL_ERROR);
        }
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        authSession.setAuthNote(OVERRIDE_LINK, "true");
        context.success();
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return false;
    }
}

