/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured.assertion;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.security.oauthbearer.internals.secured.assertion.AssertionJwtTemplate;
import org.apache.kafka.common.utils.Time;

public class DynamicAssertionJwtTemplate
implements AssertionJwtTemplate {
    private final Time time;
    private final String algorithm;
    private final int expSeconds;
    private final int nbfSeconds;
    private final boolean includeJti;

    public DynamicAssertionJwtTemplate(Time time, String algorithm, int expSeconds, int nbfSeconds, boolean includeJti) {
        this.time = time;
        this.algorithm = algorithm;
        this.expSeconds = expSeconds;
        this.nbfSeconds = nbfSeconds;
        this.includeJti = includeJti;
    }

    @Override
    public Map<String, Object> header() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("alg", this.algorithm);
        values.put("typ", "JWT");
        return Collections.unmodifiableMap(values);
    }

    @Override
    public Map<String, Object> payload() {
        long currentTimeSecs = this.time.milliseconds() / 1000L;
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("iat", currentTimeSecs);
        values.put("exp", currentTimeSecs + (long)this.expSeconds);
        values.put("nbf", currentTimeSecs - (long)this.nbfSeconds);
        if (this.includeJti) {
            values.put("jti", UUID.randomUUID().toString());
        }
        return Collections.unmodifiableMap(values);
    }
}

