import { __exports as lib } from '../../../_virtual/index4.js';
import { __require as requireAriaPropsMap } from './ariaPropsMap.js';
import { __require as requireDomMap } from './domMap.js';
import { __require as requireRolesMap } from './rolesMap.js';
import { __require as requireElementRoleMap } from './elementRoleMap.js';
import { __require as requireRoleElementMap } from './roleElementMap.js';

var hasRequiredLib;

function requireLib () {
	if (hasRequiredLib) return lib;
	hasRequiredLib = 1;

	Object.defineProperty(lib, "__esModule", {
	  value: true
	});
	lib.roles = lib.roleElements = lib.elementRoles = lib.dom = lib.aria = undefined;
	var _ariaPropsMap = _interopRequireDefault(requireAriaPropsMap());
	var _domMap = _interopRequireDefault(requireDomMap());
	var _rolesMap = _interopRequireDefault(requireRolesMap());
	var _elementRoleMap = _interopRequireDefault(requireElementRoleMap());
	var _roleElementMap = _interopRequireDefault(requireRoleElementMap());
	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var aria = _ariaPropsMap.default;
	lib.aria = aria;
	var dom = _domMap.default;
	lib.dom = dom;
	var roles = _rolesMap.default;
	lib.roles = roles;
	var elementRoles = _elementRoleMap.default;
	lib.elementRoles = elementRoles;
	var roleElements = _roleElementMap.default;
	lib.roleElements = roleElements;
	return lib;
}

export { requireLib as __require };
//# sourceMappingURL=index.js.map
