import { jsx } from 'react/jsx-runtime';
import { useState, useEffect } from 'react';
import { Input } from '@grafana/ui';
import { useDebounce } from '../../hooks/useDebounce.js';

const DebounceInput = (props) => {
  const { delay, onDebounce, value, ...rest } = props;
  const [input, setInput] = useState(value);
  const debouncedInput = useDebounce(input, delay);
  useEffect(() => onDebounce(debouncedInput), [debouncedInput]);
  useEffect(() => setInput(value), [value]);
  return /* @__PURE__ */ jsx(Input, { onChange: (ev) => setInput(ev.currentTarget.value), value: input, ...rest });
};

export { DebounceInput };
//# sourceMappingURL=DebounceInput.js.map
