---
stage: AI-powered
group: Workflow Catalog
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: プランナーエージェント
---

{{< details >}}

- プラン: Premium、Ultimate
- アドオン: GitLab Duo Core、Pro、またはEnterprise
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

この機能は、[GitLabクレジット](../../../../subscriptions/gitlab_credits.md)を使用します。

{{< /details >}}

{{< history >}}

- GitLab 18.6でベータ版として[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/576618)されました。
- GitLab 18.7で作成および編集機能が導入されました。
- GitLab 18.8で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/work_items/585273)になりました。

{{< /history >}}

プランナーエージェントは、GitLabの製品管理および計画ワークフローを支援する特殊なAIエージェントこれは、以下を組み合わせることで、より効果的に作業を作成、優先順位付け、追跡するのに役立ちます:

- 製品管理の専門知識。
- イシューやエピックなど、GitLabの計画オブジェクトの認識。

以下について支援が必要な場合は、プランナーエージェントを使用してください:

- 優先順位: RICE、MoSCoW、WSJFなどのフレームワークを適用して、作業アイテムをランク付けします。
- 作業分解: イニシアチブをエピック、機能、ユーザーストーリーに分解します。
- 作成: 価値を提供するためのメモの起草またはオブジェクトの作成。
- 依存分析: ブロックされた作業を特定し、アイテム間の関係を理解します。
- 編集: 既存のオブジェクトを編集して、時間を節約し、効率性を向上させます。
- 計画セッション: スプリント、マイルストーン、または四半期ごとの計画を編成します。
- ステータスレポート: 進捗状況、リスク、ブロッカーの概要を生成します。
- バックログ管理: 古いイシュー、重複、または改善が必要なアイテムを特定します。
- 見積もり: 作業アイテムの相対的なサイジングまたは労力見積もりを示唆します。

[イシュー583008](https://gitlab.com/gitlab-org/gitlab/-/work_items/583008)でフィードバックをお寄せください。

## プランナーエージェントにアクセスする {#access-the-planner-agent}

前提条件: 

- 基本エージェントを[オン](_index.md#turn-foundational-agents-on-or-off)にする必要があります。

1. 上部のバーで、**検索または移動先**を選択して、プロジェクトまたはグループを見つけます。
1. イシュー、エピック、またはマージリクエストを開きます。
1. GitLab Duoのサイドバーで、**新しいGitLab Duo Chat**（{{< icon name="pencil-square" >}}）または**現在のGitLab Duo Chat**（{{< icon name="duo-chat" >}}）を選択します。

   画面右側のGitLab Duoサイドバーに、Chatの会話が表示されます。

1. **New chat**（{{< icon name="duo-chat-new" >}}）ドロップダウンリストから、**プランナー**を選択します。
1. 計画関連の質問またはリクエストを入力します。リクエストから最良の結果を得るには、次の点に留意してください:

   - URL、フィルター条件、またはスコープなど、リクエストに関するコンテキストを提供します。
   - 優先順位付けフレームワークがある場合は、それを指定してください。
   - エージェントの仮定がワークフローと一致しない場合は、説明を求めてください。

### プロンプトの例 {#example-prompts}

- 「この作業アイテムの進捗状況に関するエグゼクティブサマリーを生成してください: （URLを挿入）」
- 「目的、成功基準、主要な関係者を含む、この作業アイテム（URLを挿入）のメモの下書きを作成してください。」
- 「この作業アイテムを実装するには、どのようなタスクが必要ですか？」
- 「これ（URLを挿入）について、APIのニーズ、データモデル、インテグレーションポイントを含む、技術要件の作業アイテムを下書きしてください。」
- 「どの作業アイテムが期日を過ぎていますか？」
- 「これらの作業アイテム間の関係性と順序について、依存関係の全体像としてわかるよう、作業アイテムにわかりやすく記載してください: （URLを挿入）。」
- 「6か月間更新されていない古い作業アイテムを見つけてください。」
- 「このプロジェクトで重複または類似の作業アイテムを特定してください。」
- 「このイニシアチブ（URLを挿入）を、提供する必要がある主要な機能に分解してください。」
- 「この作業アイテムに含まれる機能は、どのような順序で進めるべきですか？（URLを挿入）？」
- 「スコープを削減するために、この作業アイテム（URLを挿入）で何を延期する必要がありますか？」
- 「この作業アイテム（URLを挿入）を完了としてクローズしてください。良かった点と改善点を記録する振り返り用の作業アイテムを新たに作成し、クローズした作業アイテムにリンクしてください。」
- 「私に割り当てられた作業アイテムを表示してください。」
- 「リーダー向けに、ブロッカーと軽減計画をまとめてください: （URLを挿入）」
- 「これらの作業アイテムを論理的なリリーステーマにグループ化してください: （URLを挿入）」
- 「これらの作業アイテムを第1四半期の戦略的価値に基づいてランク付けしてください。」
- 「このプロジェクトの段階的なアプローチを提案してください: （URLを挿入）」
- 「RICEフレームワークを使用して、（ラベル名を挿入）ラベルが付いたバックログの作業アイテムの優先順位付けを手伝ってください。」
- 「締め切りに間に合わせるために、この作業アイテムの子アイテムのうち、現在のスコープから削除する必要があるのはどれですか？」
- 「この機能のMVPバージョンはどのようなものになりますか？（URLを挿入）」
- 「技術的負債と新機能を比較し、優先順位を付けるのを手伝ってください。」
- 「工数と影響度のマトリクスを使用して、これらの機能（URLを挿入）を比較してください。」
- 「顧客への影響に基づき、基準（基準を挿入）を使用してMoSCoW方式で機能を分類してください。」
