/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.util.function.Supplier;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.map.MapModel;
import org.freeplane.view.swing.map.MapView;

class FilterCache {
    private Filter cachedFilter;
    private MapModel cachedMapModel;

    FilterCache() {
    }

    Filter prepare(MapView mapView, Supplier<Filter> filterFactory) {
        MapModel mapModel = mapView.getMap();
        if (this.cachedFilter == null || this.cachedMapModel != mapModel) {
            this.cachedFilter = filterFactory.get();
            this.cachedMapModel = mapModel;
        }
        if (this.cachedFilter != null) {
            this.cachedFilter.calculateFilterResults(mapModel);
        }
        return this.cachedFilter;
    }

    void refresh(MapView mapView) {
        if (this.cachedFilter != null && mapView.getMap() == this.cachedMapModel) {
            this.cachedFilter.calculateFilterResults(this.cachedMapModel);
        }
    }

    void reset() {
        this.cachedFilter = null;
        this.cachedMapModel = null;
    }

    Filter current() {
        return this.cachedFilter;
    }
}

