/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.access.DBAuthUtils;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class ChangePasswordDialogHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(ChangePasswordDialogHandler.class);

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        DBAUserPasswordManager changePassword;
        DBNDataSource dataSource;
        DBPDataSourceContainer dataSourceContainer;
        DBPDataSource dbpDataSource;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        DBNNode node = NavigatorUtils.getSelectedNode((ISelection)selection);
        if (node instanceof DBNDataSource && (dbpDataSource = (dataSourceContainer = (dataSource = (DBNDataSource)node).getDataSourceContainer()).getDataSource()) instanceof IAdaptable && (changePassword = (DBAUserPasswordManager)((IAdaptable)dbpDataSource).getAdapter(DBAUserPasswordManager.class)) != null) {
            try {
                UIUtils.runInProgressService(monitor -> DBAuthUtils.promptAndChangePasswordForCurrentUser((DBRProgressMonitor)monitor, (DBPDataSourceContainer)dataSourceContainer, (DBAUserPasswordManager)changePassword));
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getTargetException());
            }
            catch (InterruptedException e) {
                DBWorkbench.getPlatformUI().showError("Change user password", "User password change error", (Throwable)e);
            }
        }
        return null;
    }
}

