/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class ReaderWriterLock<MUTATOR> {
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Supplier<MUTATOR> mutatorSupplier;

    public ReaderWriterLock(Supplier<MUTATOR> mutatorSupplier) {
        this.mutatorSupplier = mutatorSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RESULT, EXCEPTION extends Throwable> RESULT compute(boolean writing, ExceptableFunction<MUTATOR, RESULT, EXCEPTION> action) throws EXCEPTION {
        Lock lock = writing ? this.rwLock.writeLock() : this.rwLock.readLock();
        lock.lock();
        try {
            RESULT RESULT = action.apply(this.mutatorSupplier.get());
            return RESULT;
        }
        finally {
            lock.unlock();
        }
    }

    public <RESULT, EXCEPTION extends Throwable> RESULT computeReading(ExceptableFunction<MUTATOR, RESULT, EXCEPTION> action) throws EXCEPTION {
        return this.compute(false, action);
    }

    public <RESULT, EXCEPTION extends Throwable> RESULT computeWriting(ExceptableFunction<MUTATOR, RESULT, EXCEPTION> action) throws EXCEPTION {
        return this.compute(true, action);
    }

    public <EXCEPTION extends Throwable> void exec(boolean writing, ExceptableConsumer<MUTATOR, EXCEPTION> action) throws EXCEPTION {
        this.compute(writing, m -> {
            action.accept(m);
            return null;
        });
    }

    public <EXCEPTION extends Throwable> void execReading(ExceptableConsumer<MUTATOR, EXCEPTION> action) throws EXCEPTION {
        this.exec(false, action);
    }

    public <EXCEPTION extends Throwable> void execWriting(ExceptableConsumer<MUTATOR, EXCEPTION> action) throws EXCEPTION {
        this.exec(true, action);
    }

    public static interface ExceptableFunction<T, RESULT, EXCEPTION extends Throwable> {
        public RESULT apply(T var1) throws EXCEPTION;
    }

    public static interface ExceptableConsumer<T, EXCEPTION extends Throwable> {
        public void accept(T var1) throws EXCEPTION;
    }
}

