/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.language;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.registry.language.PlatformLanguageDescriptor;

public class PlatformLanguageRegistry {
    private static PlatformLanguageRegistry instance = null;
    private final List<PlatformLanguageDescriptor> descriptors = new ArrayList<PlatformLanguageDescriptor>();

    public static synchronized PlatformLanguageRegistry getInstance() {
        if (instance == null) {
            instance = new PlatformLanguageRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private PlatformLanguageRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        for (IConfigurationElement ext : extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.language")) {
            PlatformLanguageDescriptor formatterDescriptor = new PlatformLanguageDescriptor(ext);
            this.descriptors.add(formatterDescriptor);
        }
    }

    public List<PlatformLanguageDescriptor> getLanguages() {
        return this.descriptors;
    }

    public PlatformLanguageDescriptor getLanguage(String id) {
        for (PlatformLanguageDescriptor descriptor : this.descriptors) {
            if (!descriptor.getCode().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    public PlatformLanguageDescriptor getLanguage(Locale locale) {
        for (PlatformLanguageDescriptor descriptor : this.descriptors) {
            if (!descriptor.getCode().equals(locale.toString())) continue;
            return descriptor;
        }
        for (PlatformLanguageDescriptor descriptor : this.descriptors) {
            if (!descriptor.getCode().equals(locale.getLanguage())) continue;
            return descriptor;
        }
        return null;
    }
}

