/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class AltibaseProperty
implements DBSObject {
    private static final Log log = Log.getLog(AltibaseProperty.class);
    private final AltibaseDataSource dataSource;
    private final String name;
    private String description;
    private boolean dynamic;
    private long attr;

    public AltibaseProperty(AltibaseDataSource dataSource, JDBCResultSet dbResult) {
        this.dataSource = dataSource;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NAME");
        int valueCount = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"STOREDCOUNT");
        this.attr = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"ATTR");
        String min = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"MIN");
        String max = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"MAX");
        boolean bl = this.dynamic = (this.attr & 2L) == 0L;
        if (CommonUtils.isNotEmpty((String)min) || CommonUtils.isNotEmpty((String)max)) {
            this.description = String.format("%s  [%s, %s]", JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VALUE1"), CommonUtils.isEmpty((String)min) ? "" : min, CommonUtils.isEmpty((String)max) ? "" : max);
        } else {
            this.description = "";
            for (int i = 0; i < valueCount; ++i) {
                String tmp = JDBCUtils.safeGetString((ResultSet)dbResult, (String)("VALUE" + (i + 1)));
                if (CommonUtils.isEmpty((String)tmp)) continue;
                if (!CommonUtils.isEmpty((String)this.description)) {
                    this.description = this.description + ", ";
                }
                this.description = this.description + tmp;
            }
        }
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public boolean getDynamic() {
        return this.dynamic;
    }

    @Property(viewable=true, order=3)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isPersisted() {
        return true;
    }

    public DBSObject getParentObject() {
        return this.getDataSource();
    }

    @NotNull
    public AltibaseDataSource getDataSource() {
        return this.dataSource;
    }
}

