/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreEventTrigger;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTriggerManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class PostgreEventTriggerManager
extends SQLTriggerManager<PostgreEventTrigger, PostgreDatabase>
implements DBEObjectRenamer<PostgreEventTrigger> {
    public boolean canCreateObject(@NotNull Object container) {
        return true;
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    public DBSObjectCache<? extends DBSObject, PostgreEventTrigger> getObjectsCache(PostgreEventTrigger object) {
        return object.getDatabase().getEventTriggersCache();
    }

    protected PostgreEventTrigger createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        return new PostgreEventTrigger((PostgreDatabase)container, "new_event_trigger");
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            this.createOrReplaceTriggerQuery(monitor, executionContext, actions, (PostgreEventTrigger)command.getObject(), false);
        }
    }

    protected void addObjectExtraActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.NestedObjectCommand<PostgreEventTrigger, SQLObjectEditor.PropertyHandler> command, @NotNull Map<String, Object> options) {
        if (command.hasProperty((Object)"description")) {
            PostgreEventTrigger trigger = (PostgreEventTrigger)command.getObject();
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment event trigger", "COMMENT ON EVENT TRIGGER " + DBUtils.getQuotedIdentifier((DBSObject)trigger) + " IS " + SQLUtils.quoteString((DBSObject)trigger, (String)CommonUtils.notEmpty((String)trigger.getDescription()))));
        }
    }

    protected void createOrReplaceTriggerQuery(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull PostgreEventTrigger trigger, boolean create) {
        if (trigger.isPersisted()) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop event trigger", "DROP EVENT TRIGGER IF EXISTS " + DBUtils.getQuotedIdentifier((DBSObject)trigger)));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create trigger", trigger.getBody()));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop event trigger", "DROP EVENT TRIGGER " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject()))));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreEventTrigger object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        PostgreDataSource dataSource = ((PostgreEventTrigger)command.getObject()).getDataSource();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename event trigger", "ALTER EVENT TRIGGER " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }
}

