# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class ActionType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the action to take on rule match.
    """

    ALLOW = "Allow"
    BLOCK = "Block"
    LOG = "Log"
    REDIRECT = "Redirect"

class AfdCertificateType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the source of the SSL certificate.
    """

    CUSTOMER_CERTIFICATE = "CustomerCertificate"
    MANAGED_CERTIFICATE = "ManagedCertificate"
    AZURE_FIRST_PARTY_MANAGED_CERTIFICATE = "AzureFirstPartyManagedCertificate"

class AFDEndpointProtocols(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Supported protocols for the customer's endpoint.
    """

    HTTP = "Http"
    HTTPS = "Https"

class AfdMinimumTlsVersion(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """TLS protocol version that will be used for Https
    """

    TLS10 = "TLS10"
    TLS12 = "TLS12"

class AfdProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning status
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"
    DELETING = "Deleting"
    CREATING = "Creating"

class AfdQueryStringCachingBehavior(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Defines how Frontdoor caches requests that include query strings. You can ignore any query
    strings when caching, ignore specific query strings, cache every request with a unique URL, or
    cache specific query strings.
    """

    IGNORE_QUERY_STRING = "IgnoreQueryString"
    USE_QUERY_STRING = "UseQueryString"
    IGNORE_SPECIFIED_QUERY_STRINGS = "IgnoreSpecifiedQueryStrings"
    INCLUDE_SPECIFIED_QUERY_STRINGS = "IncludeSpecifiedQueryStrings"

class Algorithm(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Algorithm to use for URL signing
    """

    SHA256 = "SHA256"

class AutoGeneratedDomainNameLabelScope(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates the endpoint name reuse scope. The default value is TenantReuse.
    """

    TENANT_REUSE = "TenantReuse"
    SUBSCRIPTION_REUSE = "SubscriptionReuse"
    RESOURCE_GROUP_REUSE = "ResourceGroupReuse"
    NO_REUSE = "NoReuse"

class CacheBehavior(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Caching behavior for the requests
    """

    BYPASS_CACHE = "BypassCache"
    OVERRIDE = "Override"
    SET_IF_MISSING = "SetIfMissing"

class CacheType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The level at which the content needs to be cached.
    """

    ALL = "All"

class CertificateSource(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the source of the SSL certificate.
    """

    AZURE_KEY_VAULT = "AzureKeyVault"
    CDN = "Cdn"

class CertificateType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of certificate used
    """

    SHARED = "Shared"
    DEDICATED = "Dedicated"

class ClientPortOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class CookiesOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class CustomDomainResourceState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the custom domain.
    """

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"

class CustomHttpsProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning status of Custom Https of the custom domain.
    """

    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    FAILED = "Failed"

class CustomHttpsProvisioningSubstate(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by
    step.
    """

    SUBMITTING_DOMAIN_CONTROL_VALIDATION_REQUEST = "SubmittingDomainControlValidationRequest"
    PENDING_DOMAIN_CONTROL_VALIDATION_R_EQUEST_APPROVAL = "PendingDomainControlValidationREquestApproval"
    DOMAIN_CONTROL_VALIDATION_REQUEST_APPROVED = "DomainControlValidationRequestApproved"
    DOMAIN_CONTROL_VALIDATION_REQUEST_REJECTED = "DomainControlValidationRequestRejected"
    DOMAIN_CONTROL_VALIDATION_REQUEST_TIMED_OUT = "DomainControlValidationRequestTimedOut"
    ISSUING_CERTIFICATE = "IssuingCertificate"
    DEPLOYING_CERTIFICATE = "DeployingCertificate"
    CERTIFICATE_DEPLOYED = "CertificateDeployed"
    DELETING_CERTIFICATE = "DeletingCertificate"
    CERTIFICATE_DELETED = "CertificateDeleted"

class CustomRuleEnabledState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not
    specified.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class DeleteRule(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes the action that shall be taken when the certificate is removed from Key Vault.
    """

    NO_ACTION = "NoAction"

class DeliveryRuleActionEnum(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the action for the delivery rule.
    """

    CACHE_EXPIRATION = "CacheExpiration"
    CACHE_KEY_QUERY_STRING = "CacheKeyQueryString"
    MODIFY_REQUEST_HEADER = "ModifyRequestHeader"
    MODIFY_RESPONSE_HEADER = "ModifyResponseHeader"
    URL_REDIRECT = "UrlRedirect"
    URL_REWRITE = "UrlRewrite"
    URL_SIGNING = "UrlSigning"
    ORIGIN_GROUP_OVERRIDE = "OriginGroupOverride"
    ROUTE_CONFIGURATION_OVERRIDE = "RouteConfigurationOverride"

class DeploymentStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    NOT_STARTED = "NotStarted"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class DestinationProtocol(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Protocol to use for the redirect. The default value is MatchRequest
    """

    MATCH_REQUEST = "MatchRequest"
    HTTP = "Http"
    HTTPS = "Https"

class DomainValidationState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by
    step. DCV stands for DomainControlValidation.
    """

    UNKNOWN = "Unknown"
    SUBMITTING = "Submitting"
    PENDING = "Pending"
    REJECTED = "Rejected"
    TIMED_OUT = "TimedOut"
    PENDING_REVALIDATION = "PendingRevalidation"
    APPROVED = "Approved"
    REFRESHING_VALIDATION_TOKEN = "RefreshingValidationToken"
    INTERNAL_ERROR = "InternalError"

class EnabledState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class EndpointResourceState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the endpoint.
    """

    CREATING = "Creating"
    DELETING = "Deleting"
    RUNNING = "Running"
    STARTING = "Starting"
    STOPPED = "Stopped"
    STOPPING = "Stopping"

class ForwardingProtocol(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Protocol this rule will use when forwarding traffic to backends.
    """

    HTTP_ONLY = "HttpOnly"
    HTTPS_ONLY = "HttpsOnly"
    MATCH_REQUEST = "MatchRequest"

class GeoFilterActions(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Action of the geo filter, i.e. allow or block access.
    """

    BLOCK = "Block"
    ALLOW = "Allow"

class HeaderAction(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Action to perform
    """

    APPEND = "Append"
    OVERWRITE = "Overwrite"
    DELETE = "Delete"

class HealthProbeRequestType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of health probe request that is made.
    """

    NOT_SET = "NotSet"
    GET = "GET"
    HEAD = "HEAD"

class HostNameOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class HttpsRedirect(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way
    to set up this rule and it will be the first rule that gets executed.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class HttpVersionOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    EQUAL = "Equal"

class IdentityType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that creates/modifies resources
    """

    USER = "user"
    APPLICATION = "application"
    MANAGED_IDENTITY = "managedIdentity"
    KEY = "key"

class IsDeviceMatchConditionParametersMatchValuesItem(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    MOBILE = "Mobile"
    DESKTOP = "Desktop"

class IsDeviceOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    EQUAL = "Equal"

class LinkToDefaultDomain(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """whether this route will be linked to the default endpoint domain.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class LogMetric(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    CLIENT_REQUEST_COUNT = "clientRequestCount"
    CLIENT_REQUEST_TRAFFIC = "clientRequestTraffic"
    CLIENT_REQUEST_BANDWIDTH = "clientRequestBandwidth"
    ORIGIN_REQUEST_TRAFFIC = "originRequestTraffic"
    ORIGIN_REQUEST_BANDWIDTH = "originRequestBandwidth"
    TOTAL_LATENCY = "totalLatency"

class LogMetricsGranularity(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    PT5_M = "PT5M"
    PT1_H = "PT1H"
    P1_D = "P1D"

class LogMetricsGroupBy(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    HTTP_STATUS_CODE = "httpStatusCode"
    PROTOCOL = "protocol"
    CACHE_STATUS = "cacheStatus"
    COUNTRY_OR_REGION = "countryOrRegion"
    CUSTOM_DOMAIN = "customDomain"

class LogRanking(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    URL = "url"
    REFERRER = "referrer"
    BROWSER = "browser"
    USER_AGENT = "userAgent"
    COUNTRY_OR_REGION = "countryOrRegion"

class LogRankingMetric(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    CLIENT_REQUEST_COUNT = "clientRequestCount"
    CLIENT_REQUEST_TRAFFIC = "clientRequestTraffic"
    HIT_COUNT = "hitCount"
    MISS_COUNT = "missCount"
    USER_ERROR_COUNT = "userErrorCount"
    ERROR_COUNT = "errorCount"

class ManagedRuleEnabledState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not
    specified.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class MatchProcessingBehavior(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """If this rule is a match should the rules engine continue running the remaining rules or stop.
    If not present, defaults to Continue.
    """

    CONTINUE_ENUM = "Continue"
    STOP = "Stop"

class MatchVariable(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the condition for the delivery rule.
    """

    REMOTE_ADDRESS = "RemoteAddress"
    REQUEST_METHOD = "RequestMethod"
    QUERY_STRING = "QueryString"
    POST_ARGS = "PostArgs"
    REQUEST_URI = "RequestUri"
    REQUEST_HEADER = "RequestHeader"
    REQUEST_BODY = "RequestBody"
    REQUEST_SCHEME = "RequestScheme"
    URL_PATH = "UrlPath"
    URL_FILE_EXTENSION = "UrlFileExtension"
    URL_FILE_NAME = "UrlFileName"
    HTTP_VERSION = "HttpVersion"
    COOKIES = "Cookies"
    IS_DEVICE = "IsDevice"
    SOCKET_ADDR = "SocketAddr"
    CLIENT_PORT = "ClientPort"
    SERVER_PORT = "ServerPort"
    HOST_NAME = "HostName"
    SSL_PROTOCOL = "SslProtocol"

class MetricsResponseGranularity(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    PT5_M = "PT5M"
    PT1_H = "PT1H"
    P1_D = "P1D"

class MetricsResponseSeriesItemUnit(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    COUNT = "count"
    BYTES = "bytes"
    BITS_PER_SECOND = "bitsPerSecond"
    MILLI_SECONDS = "milliSeconds"

class MinimumTlsVersion(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """TLS protocol version that will be used for Https
    """

    NONE = "None"
    TLS10 = "TLS10"
    TLS12 = "TLS12"

class Operator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    IP_MATCH = "IPMatch"
    GEO_MATCH = "GeoMatch"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    LESS_THAN = "LessThan"
    GREATER_THAN = "GreaterThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    REG_EX = "RegEx"

class OptimizationType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies what scenario the customer wants this CDN endpoint to optimize, e.g. Download, Media
    services. With this information we can apply scenario driven optimization.
    """

    GENERAL_WEB_DELIVERY = "GeneralWebDelivery"
    GENERAL_MEDIA_STREAMING = "GeneralMediaStreaming"
    VIDEO_ON_DEMAND_MEDIA_STREAMING = "VideoOnDemandMediaStreaming"
    LARGE_FILE_DOWNLOAD = "LargeFileDownload"
    DYNAMIC_SITE_ACCELERATION = "DynamicSiteAcceleration"

class OriginGroupResourceState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the origin group.
    """

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"

class OriginResourceState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the origin.
    """

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"

class ParamIndicator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates the purpose of the parameter
    """

    EXPIRES = "Expires"
    KEY_ID = "KeyId"
    SIGNATURE = "Signature"

class PolicyEnabledState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """describes if the policy is in enabled state or disabled state
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class PolicyMode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes if it is in detection mode or prevention mode at policy level.
    """

    PREVENTION = "Prevention"
    DETECTION = "Detection"

class PolicyResourceState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the policy.
    """

    CREATING = "Creating"
    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    DELETING = "Deleting"

class PolicySettingsDefaultCustomBlockResponseStatusCode(with_metaclass(CaseInsensitiveEnumMeta, int, Enum)):
    """If the action type is block, this field defines the default customer overridable http response
    status code.
    """

    TWO_HUNDRED = 200
    FOUR_HUNDRED_THREE = 403
    FOUR_HUNDRED_FIVE = 405
    FOUR_HUNDRED_SIX = 406
    FOUR_HUNDRED_TWENTY_NINE = 429

class PostArgsOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class PrivateEndpointStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The approval status for the connection to the Private Link
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"
    TIMEOUT = "Timeout"

class ProbeProtocol(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Protocol to use for health probe.
    """

    NOT_SET = "NotSet"
    HTTP = "Http"
    HTTPS = "Https"

class ProfileResourceState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Resource status of the profile.
    """

    CREATING = "Creating"
    ACTIVE = "Active"
    DELETING = "Deleting"
    DISABLED = "Disabled"

class ProtocolType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Defines the TLS extension protocol that is used for secure delivery.
    """

    SERVER_NAME_INDICATION = "ServerNameIndication"
    IP_BASED = "IPBased"

class ProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the WebApplicationFirewallPolicy.
    """

    CREATING = "Creating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class QueryStringBehavior(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Caching behavior for the requests
    """

    INCLUDE = "Include"
    INCLUDE_ALL = "IncludeAll"
    EXCLUDE = "Exclude"
    EXCLUDE_ALL = "ExcludeAll"

class QueryStringCachingBehavior(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Defines how CDN caches requests that include query strings. You can ignore any query strings
    when caching, bypass caching to prevent requests that contain query strings from being cached,
    or cache every request with a unique URL.
    """

    IGNORE_QUERY_STRING = "IgnoreQueryString"
    BYPASS_CACHING = "BypassCaching"
    USE_QUERY_STRING = "UseQueryString"
    NOT_SET = "NotSet"

class QueryStringOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class RedirectType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The redirect type the rule will use when redirecting traffic.
    """

    MOVED = "Moved"
    FOUND = "Found"
    TEMPORARY_REDIRECT = "TemporaryRedirect"
    PERMANENT_REDIRECT = "PermanentRedirect"

class RemoteAddressOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    IP_MATCH = "IPMatch"
    GEO_MATCH = "GeoMatch"

class RequestBodyOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class RequestHeaderOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class RequestMethodMatchConditionParametersMatchValuesItem(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    GET = "GET"
    HEAD = "HEAD"
    POST = "POST"
    PUT = "PUT"
    DELETE = "DELETE"
    OPTIONS = "OPTIONS"
    TRACE = "TRACE"

class RequestMethodOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    EQUAL = "Equal"

class RequestSchemeMatchConditionParametersMatchValuesItem(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    HTTP = "HTTP"
    HTTPS = "HTTPS"

class RequestUriOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class ResourceType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of CDN resource used in CheckNameAvailability.
    """

    MICROSOFT_CDN_PROFILES_ENDPOINTS = "Microsoft.Cdn/Profiles/Endpoints"
    MICROSOFT_CDN_PROFILES_AFD_ENDPOINTS = "Microsoft.Cdn/Profiles/AfdEndpoints"

class ResponseBasedDetectedErrorTypes(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of response errors for real user requests for which origin will be deemed unhealthy
    """

    NONE = "None"
    TCP_ERRORS_ONLY = "TcpErrorsOnly"
    TCP_AND_HTTP_ERRORS = "TcpAndHttpErrors"

class RuleCacheBehavior(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Caching behavior for the requests
    """

    HONOR_ORIGIN = "HonorOrigin"
    OVERRIDE_ALWAYS = "OverrideAlways"
    OVERRIDE_IF_ORIGIN_MISSING = "OverrideIfOriginMissing"

class RuleIsCompressionEnabled(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates whether content compression is enabled. If compression is enabled, content will be
    served as compressed if user requests for a compressed version. Content won't be compressed on
    AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class RuleQueryStringCachingBehavior(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Defines how Frontdoor caches requests that include query strings. You can ignore any query
    strings when caching, ignore specific query strings, cache every request with a unique URL, or
    cache specific query strings.
    """

    IGNORE_QUERY_STRING = "IgnoreQueryString"
    USE_QUERY_STRING = "UseQueryString"
    IGNORE_SPECIFIED_QUERY_STRINGS = "IgnoreSpecifiedQueryStrings"
    INCLUDE_SPECIFIED_QUERY_STRINGS = "IncludeSpecifiedQueryStrings"

class SecretType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the secret resource.
    """

    URL_SIGNING_KEY = "UrlSigningKey"
    CUSTOMER_CERTIFICATE = "CustomerCertificate"
    MANAGED_CERTIFICATE = "ManagedCertificate"
    AZURE_FIRST_PARTY_MANAGED_CERTIFICATE = "AzureFirstPartyManagedCertificate"

class SecurityPolicyType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the Security policy to create.
    """

    WEB_APPLICATION_FIREWALL = "WebApplicationFirewall"

class ServerPortOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class SharedPrivateLinkResourceStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected,
    or Timeout.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"
    TIMEOUT = "Timeout"

class SkuName(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Name of the pricing tier.
    """

    STANDARD_VERIZON = "Standard_Verizon"
    PREMIUM_VERIZON = "Premium_Verizon"
    CUSTOM_VERIZON = "Custom_Verizon"
    STANDARD_AKAMAI = "Standard_Akamai"
    STANDARD_CHINA_CDN = "Standard_ChinaCdn"
    STANDARD_MICROSOFT = "Standard_Microsoft"
    STANDARD_AZURE_FRONT_DOOR = "Standard_AzureFrontDoor"
    PREMIUM_AZURE_FRONT_DOOR = "Premium_AzureFrontDoor"
    STANDARD955_BAND_WIDTH_CHINA_CDN = "Standard_955BandWidth_ChinaCdn"
    STANDARD_AVG_BAND_WIDTH_CHINA_CDN = "Standard_AvgBandWidth_ChinaCdn"
    STANDARD_PLUS_CHINA_CDN = "StandardPlus_ChinaCdn"
    STANDARD_PLUS955_BAND_WIDTH_CHINA_CDN = "StandardPlus_955BandWidth_ChinaCdn"
    STANDARD_PLUS_AVG_BAND_WIDTH_CHINA_CDN = "StandardPlus_AvgBandWidth_ChinaCdn"

class SocketAddrOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    IP_MATCH = "IPMatch"

class SslProtocol(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The protocol of an established TLS connection.
    """

    TL_SV1 = "TLSv1"
    TL_SV1_1 = "TLSv1.1"
    TL_SV1_2 = "TLSv1.2"

class SslProtocolOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    EQUAL = "Equal"

class Status(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The validation status.
    """

    VALID = "Valid"
    INVALID = "Invalid"
    ACCESS_DENIED = "AccessDenied"
    CERTIFICATE_EXPIRED = "CertificateExpired"

class Transform(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes what transforms are applied before matching
    """

    LOWERCASE = "Lowercase"
    UPPERCASE = "Uppercase"
    TRIM = "Trim"
    URL_DECODE = "UrlDecode"
    URL_ENCODE = "UrlEncode"
    REMOVE_NULLS = "RemoveNulls"

class TransformType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes what transforms were applied before matching.
    """

    LOWERCASE = "Lowercase"
    UPPERCASE = "Uppercase"
    TRIM = "Trim"
    URL_DECODE = "UrlDecode"
    URL_ENCODE = "UrlEncode"
    REMOVE_NULLS = "RemoveNulls"

class UpdateRule(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes the action that shall be taken when the certificate is updated in Key Vault.
    """

    NO_ACTION = "NoAction"

class UrlFileExtensionOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class UrlFileNameOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    REG_EX = "RegEx"

class UrlPathOperator(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes operator to be matched
    """

    ANY = "Any"
    EQUAL = "Equal"
    CONTAINS = "Contains"
    BEGINS_WITH = "BeginsWith"
    ENDS_WITH = "EndsWith"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    WILDCARD = "Wildcard"
    REG_EX = "RegEx"

class UsageUnit(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """An enum describing the unit of measurement.
    """

    COUNT = "Count"

class WafAction(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    ALLOW = "allow"
    BLOCK = "block"
    LOG = "log"
    REDIRECT = "redirect"

class WafGranularity(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    PT5_M = "PT5M"
    PT1_H = "PT1H"
    P1_D = "P1D"

class WafMatchVariable(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Match variable to compare against.
    """

    REMOTE_ADDR = "RemoteAddr"
    SOCKET_ADDR = "SocketAddr"
    REQUEST_METHOD = "RequestMethod"
    REQUEST_HEADER = "RequestHeader"
    REQUEST_URI = "RequestUri"
    QUERY_STRING = "QueryString"
    REQUEST_BODY = "RequestBody"
    COOKIES = "Cookies"
    POST_ARGS = "PostArgs"

class WafMetric(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    CLIENT_REQUEST_COUNT = "clientRequestCount"

class WafMetricsResponseGranularity(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    PT5_M = "PT5M"
    PT1_H = "PT1H"
    P1_D = "P1D"

class WafRankingGroupBy(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    HTTP_STATUS_CODE = "httpStatusCode"
    CUSTOM_DOMAIN = "customDomain"

class WafRankingType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    ACTION = "action"
    RULE_GROUP = "ruleGroup"
    RULE_ID = "ruleId"
    USER_AGENT = "userAgent"
    CLIENT_IP = "clientIp"
    URL = "url"
    COUNTRY_OR_REGION = "countryOrRegion"
    RULE_TYPE = "ruleType"

class WafRuleType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    MANAGED = "managed"
    CUSTOM = "custom"
    BOT = "bot"
