﻿#------------------------------------------------------------------------------
#
# Copyright (c) Microsoft Corporation.
# All rights reserved.
#
# This code is licensed under the MIT License.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files(the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and / or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions :
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
#------------------------------------------------------------------------------

class MsalError(Exception):
    # Define the template in Unicode to accommodate possible Unicode variables
    msg = u'An unspecified error'  # Keeping for backward compatibility


class MsalServiceError(MsalError):
    msg = u"{error}: {error_description}"  # Keeping for backward compatibility
    def __init__(
        self,
        *args,
        error: str, error_description: str,  # Historically required, keeping them for now
            # 1. We can't simply remove them, or else it will be a breaking change
            # 2. We may change them to optional without breaking anyone. However,
            #    such a change will be a one-way change, because once being optional,
            #    we will never be able to change them (back) to be required.
            # 3. Since they were required and already exist anyway,
            #    now we just keep them required "for now",
            #    just in case that we would use them again.
            # There is no plan to do #1; and we keep option #2 open; we go with #3.
        **kwargs,
    ):
        super().__init__(*args, **kwargs)
        self._error = error
        self._error_description = error_description

