# This file was auto-generated by libretiny/generate_components.py
# Do not modify its contents.
# For custom pin validators, put validate_pin() or validate_usage()
# in gpio.py file in this directory.
# For changing schema/pin schema, put COMPONENT_SCHEMA or COMPONENT_PIN_SCHEMA
# in schema.py file in this directory.

from esphome import pins
import esphome.codegen as cg
from esphome.components import libretiny
from esphome.components.libretiny.const import (
    COMPONENT_RTL87XX,
    FAMILY_RTL8710B,
    KEY_COMPONENT_DATA,
    KEY_FAMILY,
    KEY_LIBRETINY,
    LibreTinyComponent,
)
from esphome.core import CORE

from .boards import RTL87XX_BOARD_PINS, RTL87XX_BOARDS

CODEOWNERS = ["@kuba2k2"]
AUTO_LOAD = ["libretiny"]
IS_TARGET_PLATFORM = True


COMPONENT_DATA = LibreTinyComponent(
    name=COMPONENT_RTL87XX,
    boards=RTL87XX_BOARDS,
    board_pins=RTL87XX_BOARD_PINS,
    pin_validation=None,
    usage_validation=None,
)


def _set_core_data(config):
    CORE.data[KEY_LIBRETINY] = {}
    CORE.data[KEY_LIBRETINY][KEY_COMPONENT_DATA] = COMPONENT_DATA
    return config


CONFIG_SCHEMA = libretiny.BASE_SCHEMA

PIN_SCHEMA = libretiny.gpio.BASE_PIN_SCHEMA

CONFIG_SCHEMA.prepend_extra(_set_core_data)


async def to_code(config):
    # Use FreeRTOS 8.2.3+ for xTaskNotifyGive/ulTaskNotifyTake required by AsyncTCP 3.4.3+
    # https://github.com/esphome/esphome/issues/10220
    # Only for RTL8710B (ambz) - RTL8720C (ambz2) requires FreeRTOS 10.x
    if CORE.data[KEY_LIBRETINY][KEY_FAMILY] == FAMILY_RTL8710B:
        cg.add_platformio_option("custom_versions.freertos", "8.2.3")
    return await libretiny.component_to_code(config)


@pins.PIN_SCHEMA_REGISTRY.register("rtl87xx", PIN_SCHEMA)
async def pin_to_code(config):
    return await libretiny.gpio.component_pin_to_code(config)
