from esphome.config_validation import UNDEFINED

from .st7701s import ST7701S

# fmt: off
ST7701S(
    "T-PANEL-S3",
    width=480,
    height=480,
    invert_colors=False,
    swap_xy=UNDEFINED,
    spi_mode="MODE3",
    cs_pin={"xl9535": None, "number": 17},
    reset_pin={"xl9535": None, "number": 5},
    hsync_pin=39,
    vsync_pin=40,
    pclk_pin=41,
    data_pins={
        "red": [12, 13, 42, 46, 45],
        "green": [6, 7, 8, 9, 10, 11],
        "blue": [1, 2, 3, 4, 5],
    },
    hsync_front_porch=20,
    hsync_back_porch=0,
    hsync_pulse_width=2,
    vsync_front_porch=30,
    vsync_back_porch=1,
    vsync_pulse_width=8,
    pclk_frequency="6MHz",
    pclk_inverted=False,
    initsequence=(
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x13), (0xEF, 0x08), (0xFF, 0x77, 0x01, 0x00, 0x00, 0x10),
        (0xC0, 0x3B, 0x00), (0xC1, 0x0B, 0x02), (0xC2, 0x30, 0x02, 0x37), (0xCC, 0x10),
        (0xB0, 0x00, 0x0F, 0x16, 0x0E, 0x11, 0x07, 0x09, 0x09, 0x08, 0x23, 0x05, 0x11, 0x0F, 0x28, 0x2D, 0x18),
        (0xB1, 0x00, 0x0F, 0x16, 0x0E, 0x11, 0x07, 0x09, 0x08, 0x09, 0x23, 0x05, 0x11, 0x0F, 0x28, 0x2D, 0x18),
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x11),
        (0xB0, 0x4D), (0xB1, 0x33), (0xB2, 0x87), (0xB5, 0x4B), (0xB7, 0x8C), (0xB8, 0x20), (0xC1, 0x78),
        (0xC2, 0x78), (0xD0, 0x88), (0xE0, 0x00, 0x00, 0x02),
        (0xE1, 0x02, 0xF0, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, 0x44, 0x44),
        (0xE2, 0x10, 0x10, 0x40, 0x40, 0xF2, 0xF0, 0x00, 0x00, 0xF2, 0xF0, 0x00, 0x00),
        (0xE3, 0x00, 0x00, 0x11, 0x11), (0xE4, 0x44, 0x44),
        (0xE5, 0x07, 0xEF, 0xF0, 0xF0, 0x09, 0xF1, 0xF0, 0xF0, 0x03, 0xF3, 0xF0, 0xF0, 0x05, 0xED, 0xF0, 0xF0),
        (0xE6, 0x00, 0x00, 0x11, 0x11), (0xE7, 0x44, 0x44),
        (0xE8, 0x08, 0xF0, 0xF0, 0xF0, 0x0A, 0xF2, 0xF0, 0xF0, 0x04, 0xF4, 0xF0, 0xF0, 0x06, 0xEE, 0xF0, 0xF0),
        (0xEB, 0x00, 0x00, 0xE4, 0xE4, 0x44, 0x88, 0x40),
        (0xEC, 0x78, 0x00),
        (0xED, 0x20, 0xF9, 0x87, 0x76, 0x65, 0x54, 0x4F, 0xFF, 0xFF, 0xF4, 0x45, 0x56, 0x67, 0x78, 0x9F, 0x02),
        (0xEF, 0x10, 0x0D, 0x04, 0x08, 0x3F, 0x1F),
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x10),
    ),
)


t_rgb = ST7701S(
    "T-RGB-2.1",
    width=480,
    height=480,
    pixel_mode="18bit",
    invert_colors=False,
    swap_xy=UNDEFINED,
    spi_mode="MODE3",
    cs_pin={"xl9535": None, "number": 3},
    de_pin=45,
    hsync_pin=47,
    vsync_pin=41,
    pclk_pin=42,
    data_pins={
        "red": [7, 6, 5, 3, 2],
        "green": [14, 13, 12, 11, 10, 9],
        "blue": [21, 18, 17, 16, 15],
    },
    hsync_front_porch=50,
    hsync_pulse_width=1,
    hsync_back_porch=30,
    vsync_front_porch=20,
    vsync_pulse_width=1,
    vsync_back_porch=30,
    pclk_frequency="12MHz",
    pclk_inverted=False,
    initsequence=(
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x10),

        (0xC0, 0x3B, 0x00),
        (0xC1, 0x0B, 0x02),
        (0xC2, 0x07, 0x02),
        (0xCC, 0x10),
        (0xCD, 0x08),

        (0xB0,
         0x00, 0x11, 0x16, 0x0e,
         0x11, 0x06, 0x05, 0x09,
         0x08, 0x21, 0x06, 0x13,
         0x10, 0x29, 0x31, 0x18),

        (0xB1,
         0x00, 0x11, 0x16, 0x0e,
         0x11, 0x07, 0x05, 0x09,
         0x09, 0x21, 0x05, 0x13,
         0x11, 0x2a, 0x31, 0x18),

        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x11),

        (0xB0, 0x6D),
        (0xB1, 0x37),
        (0xB2, 0x81),
        (0xB3, 0x80),
        (0xB5, 0x43),
        (0xB7, 0x85),
        (0xB8, 0x20),

        (0xC1, 0x78),
        (0xC2, 0x78),
        (0xC3, 0x8C),

        (0xD0, 0x88),

        (0xE0, 0x00, 0x00, 0x02),
        (0xE1,
         0x03, 0xA0, 0x00, 0x00,
         0x04, 0xA0, 0x00, 0x00,
         0x00, 0x20, 0x20),

        (0xE2,
         0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00,
         0x00),

        (0xE3, 0x00, 0x00, 0x11, 0x00),
        (0xE4, 0x22, 0x00),

        (0xE5,
         0x05, 0xEC, 0xA0, 0xA0,
         0x07, 0xEE, 0xA0, 0xA0,
         0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00),

        (0xE6, 0x00, 0x00, 0x11, 0x00),
        (0xE7, 0x22, 0x00),

        (0xE8,
         0x06, 0xED, 0xA0, 0xA0,
         0x08, 0xEF, 0xA0, 0xA0,
         0x00, 0x00, 0x00, 0x00,
         0x00, 0x00, 0x00, 0x00),

        (0xEB, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x10),

        (0xED,
         0xFF, 0xFF, 0xFF, 0xBA,
         0x0A, 0xBF, 0x45, 0xFF,
         0xFF, 0x54, 0xFB, 0xA0,
         0xAB, 0xFF, 0xFF, 0xFF),

        (0xEF, 0x10, 0x0D, 0x04, 0x08, 0x3F, 0x1F),

        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x13),
        (0xEF, 0x08),
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x10)
    )

)
t_rgb.extend(
    "T-RGB-2.8",
    initsequence=(
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x13),
        (0xEF, 0x08),
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x10),
        (0xC0, 0x3B, 0x00),
        (0xC1, 0x10, 0x0C),
        (0xC2, 0x07, 0x0A),
        (0xC7, 0x00),
        (0xC7, 0x10),
        (0xCD, 0x08),
        (0xB0,
         0x05, 0x12, 0x98, 0x0e, 0x0F,
         0x07, 0x07, 0x09, 0x09, 0x23,
         0x05, 0x52, 0x0F, 0x67, 0x2C, 0x11),
        (0xB1,
         0x0B, 0x11, 0x97, 0x0C, 0x12,
         0x06, 0x06, 0x08, 0x08, 0x22,
         0x03, 0x51, 0x11, 0x66, 0x2B, 0x0F),
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x11),
        (0xB0, 0x5D),
        (0xB1, 0x2D),
        (0xB2, 0x81),
        (0xB3, 0x80),
        (0xB5, 0x4E),
        (0xB7, 0x85),
        (0xB8, 0x20),
        (0xC1, 0x78),
        (0xC2, 0x78),
        (0xD0, 0x88),
        (0xE0, 0x00, 0x00, 0x02),
        (0xE1,
         0x06, 0x30, 0x08, 0x30, 0x05,
         0x30, 0x07, 0x30, 0x00, 0x33,
         0x33),
        (0xE2,
         0x11, 0x11, 0x33, 0x33, 0xf4,
         0x00, 0x00, 0x00, 0xf4, 0x00,
         0x00, 0x00),
        (0xE3, 0x00, 0x00, 0x11, 0x11),
        (0xE4, 0x44, 0x44),
        (0xE5,
         0x0d, 0xf5, 0x30, 0xf0, 0x0f,
         0xf7, 0x30, 0xf0, 0x09, 0xf1,
         0x30, 0xf0, 0x0b, 0xf3, 0x30, 0xf0),
        (0xE6, 0x00, 0x00, 0x11, 0x11),
        (0xE7, 0x44, 0x44),
        (0xE8,
         0x0c, 0xf4, 0x30, 0xf0,
         0x0e, 0xf6, 0x30, 0xf0,
         0x08, 0xf0, 0x30, 0xf0,
         0x0a, 0xf2, 0x30, 0xf0),
        (0xe9, 0x36),
        (0xEB, 0x00, 0x01, 0xe4, 0xe4, 0x44, 0x88, 0x40),
        (0xED,
         0xff, 0x10, 0xaf, 0x76,
         0x54, 0x2b, 0xcf, 0xff,
         0xff, 0xfc, 0xb2, 0x45,
         0x67, 0xfa, 0x01, 0xff),
        (0xEF, 0x08, 0x08, 0x08, 0x45, 0x3f, 0x54),
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x10),
    )
)
