\name{Transform}
\alias{Transform}
\title{Transform}
\Rdversion{1.1}
\docType{class}
\description{
A simplified wrapper around a variety of ITK transforms.
Transform}
\details{
The interface to ITK transform objects to be used with the ImageRegistrationMethod, ResampleImageFilter and other SimpleITK process objects. The transforms are designed to
have a serialized array of parameters to facilitate optimization for
registration.
Provides a base class interface to any type of ITK transform. Objects
of this type may have their interface converted to a derived interface
while keeping the same reference to the ITK object.
Additionally, this class provides a basic interface to a composite
transforms.
See:
itk::CompositeTransform
Transform}
%C++ includes: sitkTransform.h
\section{Methods}{
\describe{
\item{unsigned int GetDimension() const:}{
Return the dimension of the Transform ( 2D or 3D )
}
\item{Transform GetInverse() const:}{
Return a new inverse transform of the same type as this.
Creates a new transform object and tries to set the value to the
inverse. As not all transform types have inverse and some transforms
are not invertible, an exception will be throw is there is no inverse.
}
\item{std::string GetName() const:}{
return user readable name for the SimpleITK transform
}
\item{unsigned int GetNumberOfFixedParameters() const:}{
Get the number of fixed parameters
}
\item{unsigned int GetNumberOfParameters() const:}{
Return the number of optimizable parameters
}
\item{TransformEnum GetTransformEnum() const:}{
Get the TransformEnum of the underlying Transform.
A SimpleITK Transform object can internally hold any ITK transform. This method returns the
TransformEnum representing the internal ITK transform. This value may
be used to identify which SimpleITK class the transform can be
converted to.
}
\item{bool IsLinear() const:}{}
\item{void MakeUnique():}{
Performs actually coping if needed to make object unique.
The Transform class by default performs lazy coping and assignment. This method
make sure that coping actually happens to the itk::Transform pointed to is only pointed to by this object.
}
\item{void SetIdentity():}{}
\item{bool SetInverse():}{
Try to change the current transform to it's inverse.
If the transform has an inverse, i.e. non-singular linear transforms,
then a new ITK transform is created of the same type and this object
is set to it.
However not all transform have a direct inverse, if the inverse does
not exist or fails false will be returned and this transform will not
be modified.
}
\item{std::string ToString() const:}{}
\item{ Transform():}{
By default a 3-d identity transform is constructed.
}
\item{ Transform(Image &displacement, TransformEnum type=sitkDisplacementField):}{
Use an image to construct a transform.
The input displacement image is transferred to the constructed
transform object. The input image is modified to be a default
constructed Image object.
Only the sitkDisplacementField transformation type can currently be
constructed this way. Image must be of sitkVectorFloat64 pixel type with the number of components
equal to the image dimension.
Deprecated
This constructor will be removed in future releases.
}
\item{unsigned int Transform(itk::CompositeTransform< double, NDimension > *compositeTransform):}{
Construct a SimpleITK Transform from a pointer to an ITK composite transform.
}
\item{ Transform(itk::TransformBase *transform):}{}
\item{ Transform(unsigned int dimensions, TransformEnum type):}{
Construct a specific transformation.
Deprecated
This constructor will be removed in future releases.
}
\item{std::vector< double > TransformPoint(const std::vector< double > &point) const:}{
Apply transform to a point.
The dimension of the point must match the transform.
}
\item{std::vector< double > TransformVector(const std::vector< double > &vector, const std::vector< double > &point) const:}{
Apply transform to a vector at a point.
The ITK concept of a vector is a direction at a specific point, for
example the difference between two points is a vector.
For linear transforms the point does not matter, in general the vector
is transformed by the Jacobian with respect to point position.
The dimension of the vector and point must match the transform.
}
\item{void WriteTransform(const std::string &filename) const:}{}
\item{ ~Transform():}{}
}
}
