/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;

public class XSLTResourceStream
extends AbstractResourceStream {
    private static final long serialVersionUID = 1L;
    private final transient ByteArrayOutputStream out;

    protected Map<Object, Object> getParameters() {
        return null;
    }

    public XSLTResourceStream(IResourceStream xsltResource, IResourceStream xmlResource) {
        this(xsltResource, xmlResource, XSLTResourceStream.defaultTransformerFactory());
    }

    private static TransformerFactory defaultTransformerFactory() {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        return factory;
    }

    public XSLTResourceStream(IResourceStream xsltResource, IResourceStream xmlResource, TransformerFactory transformerFactory) {
        try {
            StreamSource xmlSource = new StreamSource(xmlResource.getInputStream());
            StreamSource xsltSource = new StreamSource(xsltResource.getInputStream());
            this.out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(this.out);
            Transformer trans = transformerFactory.newTransformer(xsltSource);
            Map<Object, Object> parameters = this.getParameters();
            if (parameters != null) {
                for (Map.Entry<Object, Object> e : parameters.entrySet()) {
                    trans.setParameter(e.getKey().toString(), e.getValue().toString());
                }
            }
            trans.transform(xmlSource, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly(xmlResource);
            IOUtils.closeQuietly(xsltResource);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return new ByteArrayInputStream(this.out.toByteArray());
    }

    @Override
    public Bytes length() {
        return Bytes.bytes(this.out.size());
    }

    @Override
    public Instant lastModifiedTime() {
        return null;
    }
}

