/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;

public class FileSystemResourceStream
extends AbstractResourceStream
implements IFixedLocationResourceStream {
    private static final long serialVersionUID = 1L;
    private final Path path;
    private transient InputStream inputStream;

    public FileSystemResourceStream(Path path) {
        Args.notNull(path, "path");
        this.path = path;
    }

    public FileSystemResourceStream(File file) {
        Args.notNull(file, "file");
        this.path = file.toPath();
    }

    public FileSystemResourceStream(org.apache.wicket.util.file.File file) {
        Args.notNull(file, "file");
        this.path = file.toPath();
    }

    @Override
    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        if (this.inputStream == null) {
            try {
                this.inputStream = Files.newInputStream(this.path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new ResourceStreamNotFoundException("Input stream of path " + String.valueOf(this.path) + " could not be acquired", e);
            }
        }
        return this.inputStream;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    @Override
    public String getContentType() {
        try {
            String contentType = Files.probeContentType(this.path);
            if (contentType == null) {
                contentType = URLConnection.getFileNameMap().getContentTypeFor(this.path.getFileName().toString());
            }
            return contentType;
        }
        catch (IOException e) {
            throw new RuntimeException("Content type of path " + String.valueOf(this.path) + " could not be acquired", e);
        }
    }

    public final Path getPath() {
        return this.path;
    }

    @Override
    public Instant lastModifiedTime() {
        try {
            BasicFileAttributes attributes = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
            FileTime lastModifiedTime = attributes.lastModifiedTime();
            long millis = lastModifiedTime.toMillis();
            return Instant.ofEpochMilli(millis);
        }
        catch (IOException e) {
            throw new RuntimeException("Modification time of path " + String.valueOf(this.path) + " could not be acquired", e);
        }
    }

    @Override
    public Bytes length() {
        try {
            BasicFileAttributes attributes = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]);
            long size = attributes.size();
            return Bytes.bytes(size);
        }
        catch (IOException e) {
            throw new RuntimeException("Length of path " + String.valueOf(this.path) + " could not be acquired", e);
        }
    }

    @Override
    public String locationAsString() {
        return this.path.toString();
    }

    public String toString() {
        return this.locationAsString();
    }
}

