/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import org.apache.wicket.Session;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.time.Duration;

public class UploadInfo
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private transient long timeStarted = System.currentTimeMillis();
    private transient long totalBytes;
    private transient long bytesUploaded;

    public UploadInfo(int totalBytes) {
        this.totalBytes = totalBytes;
    }

    public long getBytesUploaded() {
        return this.bytesUploaded;
    }

    public void setBytesUploaded(long bytesUploaded) {
        this.bytesUploaded = bytesUploaded;
    }

    public String getBytesUploadedString() {
        return Bytes.bytes((long)this.bytesUploaded).toString(Session.get().getLocale());
    }

    public String getTotalBytesString() {
        return Bytes.bytes((long)this.totalBytes).toString(Session.get().getLocale());
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getElapsedMilliseconds() {
        return System.currentTimeMillis() - this.timeStarted;
    }

    public long getElapsedSeconds() {
        return this.getElapsedMilliseconds() / 1000L;
    }

    public long getTransferRateBPS() {
        return this.bytesUploaded / Math.max(this.getElapsedSeconds(), 1L);
    }

    public String getTransferRateString() {
        return Bytes.bytes((long)this.getTransferRateBPS()).toString(Session.get().getLocale()) + "/s";
    }

    public int getPercentageComplete() {
        if (this.totalBytes == 0L) {
            return 100;
        }
        return (int)((double)this.bytesUploaded / (double)this.totalBytes * 100.0);
    }

    public long getRemainingMilliseconds() {
        int percentageComplete = this.getPercentageComplete();
        long totalTime = this.getElapsedSeconds() * 100L / (long)Math.max(percentageComplete, 1);
        long remainingTime = totalTime - this.getElapsedSeconds();
        return remainingTime * 1000L;
    }

    public String getRemainingTimeString() {
        return Duration.milliseconds((long)this.getRemainingMilliseconds()).toString(Session.get().getLocale());
    }
}

