/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.captcha.kittens;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.util.string.StringList;

class OpaqueRegion {
    private final List<Rectangle> rectangles;

    OpaqueRegion(BufferedImage image) {
        if (image.getType() != 2) {
            throw new IllegalArgumentException("image must be TYPE_INT_ARGB");
        }
        this.rectangles = new ArrayList<Rectangle>();
        ColorModel colorModel = image.getColorModel();
        int dx = image.getWidth();
        int dy = image.getHeight();
        for (int y = 0; y < dy; ++y) {
            int startx = -1;
            for (int x = 0; x < dx; ++x) {
                int pixel = image.getRGB(x, y);
                if (colorModel.getAlpha(pixel) > 0) {
                    if (startx != -1) continue;
                    startx = x;
                    continue;
                }
                if (startx == -1) continue;
                this.rectangles.add(new Rectangle(startx, y, x - startx - 1, 1));
                startx = -1;
            }
            if (startx == -1) continue;
            this.rectangles.add(new Rectangle(startx, y, dx - startx - 1, 1));
        }
    }

    private OpaqueRegion(List<Rectangle> rectangles) {
        this.rectangles = rectangles;
    }

    public String toString() {
        return StringList.valueOf(this.rectangles).join();
    }

    int areaInPixels() {
        int area = 0;
        for (Rectangle rectangle : this.rectangles) {
            area += rectangle.width * rectangle.height;
        }
        return area;
    }

    boolean contains(Point point) {
        for (Rectangle rectangle : this.rectangles) {
            if (!rectangle.contains(point.x, point.y)) continue;
            return true;
        }
        return false;
    }

    int height() {
        int height = 0;
        for (Rectangle rectangle : this.rectangles) {
            int y2 = rectangle.y + rectangle.height;
            if (y2 <= height) continue;
            height = y2;
        }
        return height;
    }

    OpaqueRegion subtract(OpaqueRegion removeRegion, Point offset) {
        ArrayList<Rectangle> newRectangles = new ArrayList<Rectangle>();
        for (Rectangle rectangle : this.rectangles) {
            int y = rectangle.y;
            ArrayList<Rectangle> workList = new ArrayList<Rectangle>();
            workList.add(new Rectangle(rectangle));
            for (Rectangle remove : removeRegion.rectangles) {
                Rectangle offsetRemove = new Rectangle(remove);
                offsetRemove.translate(offset.x, offset.y);
                if (offsetRemove.y > y) break;
                if (offsetRemove.y != y) continue;
                int rx1 = offsetRemove.x;
                int rx2 = offsetRemove.x + offsetRemove.width;
                for (int i = 0; i < workList.size(); ++i) {
                    boolean rightIn;
                    Rectangle work = (Rectangle)workList.get(i);
                    int x1 = work.x;
                    int x2 = work.x + work.width;
                    if (rx1 <= x1 && rx2 >= x2) {
                        workList.remove(i);
                        --i;
                        continue;
                    }
                    boolean leftIn = rx1 >= x1 && rx1 < x2;
                    boolean bl = rightIn = rx2 > x1 && rx2 <= x2;
                    if (leftIn) {
                        if (rightIn) {
                            if (rx1 - x1 > 0) {
                                workList.set(i, new Rectangle(x1, y, rx1 - x1, 1));
                            }
                            if (x2 - rx2 <= 0) continue;
                            workList.add(i + 1, new Rectangle(rx2, y, x2 - rx2, 1));
                            continue;
                        }
                        if (rx1 - x1 <= 0) continue;
                        workList.set(i, new Rectangle(x1, y, rx1 - x1, 1));
                        continue;
                    }
                    if (!rightIn || x2 - rx2 <= 0) continue;
                    workList.set(i, new Rectangle(rx2, y, x2 - rx2, 1));
                }
            }
            newRectangles.addAll(workList);
        }
        return new OpaqueRegion(newRectangles);
    }

    BufferedImage toDebugImage() {
        int dx = this.width();
        int dy = this.height();
        BufferedImage image = new BufferedImage(dx, dy, 2);
        for (int y = 0; y < dy; ++y) {
            for (int x = 0; x < dx; ++x) {
                image.setRGB(x, y, 0);
            }
        }
        for (Rectangle rectangle : this.rectangles) {
            for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                image.setRGB(x, rectangle.y, -16711936);
            }
        }
        return image;
    }

    int width() {
        int width = 0;
        for (Rectangle rectangle : this.rectangles) {
            int x2 = rectangle.x + rectangle.width;
            if (x2 <= width) continue;
            width = x2;
        }
        return width;
    }
}

