/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper.info;

import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class ComponentInfo {
    private static final char BEHAVIOR_INDEX_SEPARATOR = '.';
    private static final char SEPARATOR = '-';
    private static final char COMPONENT_SEPARATOR = ':';
    private static final char SEPARATOR_ENCODED = '~';
    private final String componentPath;
    private final Integer behaviorId;
    private final Integer renderCount;

    private static String encodeComponentPath(CharSequence path) {
        if (path != null) {
            int length = path.length();
            if (length == 0) {
                return path.toString();
            }
            StringBuilder result = new StringBuilder(length);
            block4: for (int i = 0; i < length; ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case ':': {
                        result.append('-');
                        continue block4;
                    }
                    case '-': {
                        result.append('~');
                        continue block4;
                    }
                    default: {
                        result.append(c);
                    }
                }
            }
            return result.toString();
        }
        return null;
    }

    private static String decodeComponentPath(CharSequence path) {
        if (path != null) {
            int length = path.length();
            if (length == 0) {
                return path.toString();
            }
            StringBuilder result = new StringBuilder(length);
            block4: for (int i = 0; i < length; ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case '~': {
                        result.append('-');
                        continue block4;
                    }
                    case '-': {
                        result.append(':');
                        continue block4;
                    }
                    default: {
                        result.append(c);
                    }
                }
            }
            return result.toString();
        }
        return null;
    }

    public ComponentInfo(Integer renderCount, String componentPath, Integer behaviorId) {
        Args.notNull((Object)componentPath, (String)"componentPath");
        this.componentPath = componentPath;
        this.behaviorId = behaviorId;
        this.renderCount = renderCount;
    }

    public String getComponentPath() {
        return this.componentPath;
    }

    public Integer getBehaviorId() {
        return this.behaviorId;
    }

    public Integer getRenderCount() {
        return this.renderCount;
    }

    public String toString() {
        String path = ComponentInfo.encodeComponentPath(this.componentPath);
        StringBuilder result = new StringBuilder(path.length() + 12);
        if (this.renderCount != null) {
            result.append(this.renderCount);
        }
        if (this.renderCount != null || this.behaviorId != null) {
            result.append('.');
        }
        if (this.behaviorId != null) {
            result.append(this.behaviorId);
        }
        result.append('-');
        result.append(path);
        return result.toString();
    }

    private static boolean isNumber(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static ComponentInfo parse(String string) {
        if (Strings.isEmpty((String)string)) {
            return null;
        }
        int i = string.indexOf(45);
        if (i == -1) {
            return null;
        }
        String listener = string.substring(0, i);
        String componentPath = ComponentInfo.decodeComponentPath(string.substring(i + 1));
        Integer behaviorIndex = null;
        Integer renderCount = null;
        String[] listenerParts = Strings.split((String)listener, (char)'.');
        if (listenerParts.length == 0) {
            return new ComponentInfo(renderCount, componentPath, behaviorIndex);
        }
        if (listenerParts.length == 2) {
            if (ComponentInfo.isNumber(listenerParts[0])) {
                renderCount = Integer.valueOf(listenerParts[0]);
            }
            if (ComponentInfo.isNumber(listenerParts[1])) {
                behaviorIndex = Integer.valueOf(listenerParts[1]);
            }
            return new ComponentInfo(renderCount, componentPath, behaviorIndex);
        }
        return null;
    }
}

