/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.css.ICssCompressor;
import org.apache.wicket.resource.IScopeAwareTextResourceProcessor;

public class CompositeCssCompressor
implements IScopeAwareTextResourceProcessor,
ICssCompressor {
    private final List<ICssCompressor> compressors = new ArrayList<ICssCompressor>();

    public CompositeCssCompressor(ICssCompressor ... compressors) {
        this.compressors.addAll(Arrays.asList(compressors));
    }

    @Override
    public String process(String input, Class<?> scope, String name) {
        String compressed = input;
        for (ICssCompressor compressor : this.compressors) {
            if (compressor instanceof IScopeAwareTextResourceProcessor) {
                IScopeAwareTextResourceProcessor processor = (IScopeAwareTextResourceProcessor)((Object)compressor);
                compressed = processor.process(compressed, scope, name);
                continue;
            }
            compressed = compressor.compress(compressed);
        }
        return compressed;
    }

    @Override
    public String compress(String original) {
        throw new UnsupportedOperationException(CompositeCssCompressor.class.getSimpleName() + ".process() should be used instead!");
    }

    public CompositeCssCompressor add(ICssCompressor compressor) {
        this.compressors.add(compressor);
        return this;
    }
}

