/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.https;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.wicket.Session;
import org.apache.wicket.core.request.handler.IPageClassRequestHandler;
import org.apache.wicket.protocol.https.HttpsConfig;
import org.apache.wicket.protocol.https.RequireHttps;
import org.apache.wicket.protocol.https.Scheme;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.IRequestMapperDelegate;
import org.apache.wicket.util.collections.ClassMetaCache;
import org.apache.wicket.util.lang.Args;

public class HttpsMapper
implements IRequestMapperDelegate {
    private final HttpsConfig config;
    private final IRequestMapper delegate;
    private final ClassMetaCache<Scheme> cache = new ClassMetaCache();

    public HttpsMapper(IRequestMapper delegate, HttpsConfig config) {
        this.delegate = (IRequestMapper)Args.notNull((Object)delegate, (String)"delegate");
        this.config = config;
    }

    public IRequestMapper getDelegateMapper() {
        return this.delegate;
    }

    public final int getCompatibilityScore(Request request) {
        return this.delegate.getCompatibilityScore(request);
    }

    public final IRequestHandler mapRequest(Request request) {
        IRequestHandler handler = this.delegate.mapRequest(request);
        Scheme desired = this.getDesiredSchemeFor(handler);
        if (Scheme.ANY.equals((Object)desired)) {
            return handler;
        }
        Scheme current = this.getSchemeOf(request);
        if (!desired.isCompatibleWith(current)) {
            String url = this.createRedirectUrl(handler, request, desired);
            handler = this.createRedirectHandler(url);
        }
        return handler;
    }

    public final Url mapHandler(IRequestHandler handler) {
        return this.mapHandler(handler, RequestCycle.get().getRequest());
    }

    protected IRequestHandler createRedirectHandler(String url) {
        return new RedirectHandler(url, this.config);
    }

    protected String createRedirectUrl(IRequestHandler handler, Request request, Scheme scheme) {
        HttpServletRequest req = (HttpServletRequest)request.getContainerRequest();
        String url = scheme.urlName() + "://";
        url = url + req.getServerName();
        if (!scheme.usesStandardPort(this.config)) {
            url = url + ":" + scheme.getPort(this.config);
        }
        url = url + req.getRequestURI();
        if (req.getQueryString() != null) {
            url = url + "?" + req.getQueryString();
        }
        return url;
    }

    final Url mapHandler(IRequestHandler handler, Request request) {
        Url url = this.delegate.mapHandler(handler);
        Scheme desired = this.getDesiredSchemeFor(handler);
        if (Scheme.ANY.equals((Object)desired)) {
            return url;
        }
        Scheme current = this.getSchemeOf(request);
        if (!desired.isCompatibleWith(current)) {
            url.setProtocol(desired.urlName());
            url.setPort(Integer.valueOf(desired.getPort(this.config)));
        }
        return url;
    }

    protected Scheme getDesiredSchemeFor(IRequestHandler handler) {
        if (handler instanceof IPageClassRequestHandler) {
            return this.getDesiredSchemeFor(((IPageClassRequestHandler)handler).getPageClass());
        }
        return Scheme.ANY;
    }

    protected Scheme getSchemeOf(Request request) {
        HttpServletRequest req = (HttpServletRequest)request.getContainerRequest();
        if ("https".equalsIgnoreCase(req.getScheme())) {
            return Scheme.HTTPS;
        }
        if ("http".equalsIgnoreCase(req.getScheme())) {
            return Scheme.HTTP;
        }
        throw new IllegalStateException("Could not resolve protocol for request: " + String.valueOf(req));
    }

    protected Scheme getDesiredSchemeFor(Class<? extends IRequestablePage> pageClass) {
        if (pageClass == null) {
            return Scheme.ANY;
        }
        Scheme SCHEME = (Scheme)((Object)this.cache.get(pageClass));
        if (SCHEME == null) {
            SCHEME = this.hasSecureAnnotation(pageClass) ? Scheme.HTTPS : Scheme.HTTP;
            this.cache.put(pageClass, (Object)SCHEME);
        }
        return SCHEME;
    }

    public final HttpsConfig getConfig() {
        return this.config;
    }

    private boolean hasSecureAnnotation(Class<?> type) {
        if (type.getAnnotation(RequireHttps.class) != null) {
            return true;
        }
        for (Class<?> iface : type.getInterfaces()) {
            if (!this.hasSecureAnnotation(iface)) continue;
            return true;
        }
        if (type.getSuperclass() != null) {
            return this.hasSecureAnnotation(type.getSuperclass());
        }
        return false;
    }

    public static class RedirectHandler
    implements IRequestHandler {
        private final String url;
        private final HttpsConfig config;

        public RedirectHandler(String url, HttpsConfig config) {
            this.url = (String)Args.notNull((Object)url, (String)"url");
            this.config = (HttpsConfig)Args.notNull((Object)config, (String)"config");
        }

        public String getUrl() {
            return this.url;
        }

        public void respond(IRequestCycle requestCycle) {
            String location = this.url;
            if (location.startsWith("/")) {
                location = requestCycle.getUrlRenderer().renderContextRelativeUrl(location);
            }
            if (this.config.isPreferStateful()) {
                Session.get().bind();
            }
            WebResponse response = (WebResponse)requestCycle.getResponse();
            response.sendRedirect(location);
        }
    }
}

