/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.core.util.lang.PropertyResolverConverter;
import org.apache.wicket.model.ChainingModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IObjectClassAwareModel;
import org.apache.wicket.model.IPropertyReflectionAwareModel;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractPropertyModel<T>
extends ChainingModel<T>
implements IObjectClassAwareModel<T>,
IPropertyReflectionAwareModel<T> {
    private static final long serialVersionUID = 1L;

    public AbstractPropertyModel(Object modelObject) {
        super(modelObject);
    }

    @Override
    public T getObject() {
        String expression = this.propertyExpression();
        if (Strings.isEmpty((String)expression)) {
            return (T)this.getInnermostModelOrObject();
        }
        if (expression.startsWith(".")) {
            throw new IllegalArgumentException("Property expressions cannot start with a '.' character");
        }
        Object target = this.getInnermostModelOrObject();
        if (target != null) {
            return (T)PropertyResolver.getValue(expression, target);
        }
        return null;
    }

    public final String getPropertyExpression() {
        return this.propertyExpression();
    }

    @Override
    public void setObject(T object) {
        String expression = this.propertyExpression();
        if (Strings.isEmpty((String)expression)) {
            Object target = this.getTarget();
            if (target instanceof IModel) {
                ((IModel)target).setObject(object);
            } else {
                this.setTarget(object);
            }
        } else {
            PropertyResolverConverter prc = new PropertyResolverConverter(Application.get().getConverterLocator(), Session.get().getLocale());
            PropertyResolver.setValue(expression, this.getInnermostModelOrObject(), object, prc);
        }
    }

    @Override
    public Class<T> getObjectClass() {
        block8: {
            String expression = this.propertyExpression();
            Object target = this.getInnermostModelOrObject();
            if (Strings.isEmpty((String)expression)) {
                return target != null ? target.getClass() : null;
            }
            if (target != null) {
                try {
                    return PropertyResolver.getPropertyClass(expression, target);
                }
                catch (Exception exception) {
                    break block8;
                }
            }
            if (this.getTarget() instanceof IObjectClassAwareModel) {
                try {
                    Class targetClass = ((IObjectClassAwareModel)this.getTarget()).getObjectClass();
                    if (targetClass != null) {
                        return PropertyResolver.getPropertyClass(expression, targetClass);
                    }
                }
                catch (WicketRuntimeException wicketRuntimeException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public Field getPropertyField() {
        Object target;
        String expression = this.propertyExpression();
        if (!Strings.isEmpty((String)expression) && (target = this.getInnermostModelOrObject()) != null) {
            try {
                return PropertyResolver.getPropertyField(expression, target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Method getPropertyGetter() {
        Object target;
        String expression = this.propertyExpression();
        if (!Strings.isEmpty((String)expression) && (target = this.getInnermostModelOrObject()) != null) {
            try {
                return PropertyResolver.getPropertyGetter(expression, target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Method getPropertySetter() {
        Object target;
        String expression = this.propertyExpression();
        if (!Strings.isEmpty((String)expression) && (target = this.getInnermostModelOrObject()) != null) {
            try {
                return PropertyResolver.getPropertySetter(expression, target);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected abstract String propertyExpression();
}

