/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head.http2;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.wicket.markup.head.http2.IPushBuilder;
import org.apache.wicket.markup.head.http2.PushItem;
import org.apache.wicket.markup.head.http2.PushItemHeaderValue;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushBuilder
implements IPushBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(PushBuilder.class);

    @Override
    public void push(HttpServletRequest httpServletRequest, PushItem ... pushItems) {
        Request request = RequestCycle.get().getRequest();
        HttpServletRequest httpRequest = (HttpServletRequest)request.getContainerRequest();
        jakarta.servlet.http.PushBuilder pushBuilder = httpRequest.newPushBuilder();
        if (pushBuilder != null) {
            for (PushItem pushItem : pushItems) {
                pushBuilder.path(pushItem.getUrl());
                pushItem.getHeaders().entrySet().stream().forEach(pushHeader -> {
                    String key = (String)pushHeader.getKey();
                    PushItemHeaderValue value = (PushItemHeaderValue)pushHeader.getValue();
                    if (value.getOperation() == PushItemHeaderValue.HeaderOperation.ADD) {
                        pushBuilder.addHeader(key, value.getValue());
                    } else {
                        pushBuilder.setHeader(key, value.getValue());
                    }
                });
                pushBuilder.push();
            }
        } else {
            LOG.warn("Attempted to use HTTP2 Push but it is not supported for the current request: {}!", (Object)httpRequest);
        }
    }
}

